package com.roco.settle.api.service;

import com.roco.settle.api.entity.invoice.Invoice;
import com.roco.settle.api.entity.invoice.InvoiceExpressExt;
import com.roco.settle.api.entity.invoice.InvoiceOrderExt;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.invoice.*;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.invoice.InvoicePaymentOrderCodeResp;

import java.util.List;

/**
 * 发票入库管理
 * @author dongjuntong
 */
public interface InvoiceService {



    /**
     * 新增发票入库
     * @param request
     * @return
     */
    CommonResponse<Boolean> saveInvoice(CommonRequest<InvoiceSaveReq> request);


    /**
     * 修改发票
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateInvoice(CommonRequest<InvoiceSaveReq> request);



    /**
     * 分页查询发票
     * @param pageRequest
     * @return
     */
    CommonQueryPageResponse<InvoiceOrderExt> pageInvoice(CommonQueryPageRequest<InvoicePageReq> pageRequest);


    /**
     * 不分页查询发票
     * @param pageRequest
     * @return
     */
    CommonResponse<List<InvoiceOrderExt>> selectInvoices(CommonRequest<InvoicePageReq> pageRequest);


    /**
     * 更新发票状态
     * @param updateRequest
     * @return
     */
    CommonResponse<Boolean> updateStatusInvoice(CommonRequest<InvoiceUpdateStatusReq> updateRequest);


    /**
     * 查询发票详情
     * @param request
     * @return
     */
    CommonResponse<InvoiceOrderExt> detail(CommonRequest<InvoiceDetailReq > request);


    /**
     * 删除发票
     * @param request
     * @return
     */
    CommonResponse<Boolean> delete(CommonRequest<InvoiceDeleteReq> request);


    /**
     * 分页查询尚未关联订单的发票
     * @param pageRequest
     * @return
     */
    CommonQueryPageResponse<InvoiceOrderExt> selectUnconnectedInvoice(CommonQueryPageRequest<InvoicePageReq> pageRequest);


    /**
     * 分页查询尚未关联快递单的发票
     * @param pageRequest
     * @return
     */
    CommonQueryPageResponse<InvoiceExpressExt> selectUnconnectedExpressInvoice(CommonQueryPageRequest<ExpressInvoiceSelectReq> pageRequest);


    /**
     *保存发票与订单的关联关系
     * @param pageRequest
     * @return
     */
    CommonResponse<Boolean> orderInvoiceSave(CommonRequest<OrderInvoiceSaveReq> pageRequest);


    /**
     * 根据id查询发票详情
     * @param request
     * @return
     */
    CommonResponse<Invoice> selectDetailById(CommonRequest<BasePrimaryKeyRequest > request);


    /**
     * 分页查询发票关联订单信息
     * @param pageRequest
     * @return
     */
    CommonQueryPageResponse<InvoiceOrderExt> pageOrderInvoice(CommonQueryPageRequest<InvoicePageReq> pageRequest);



    /**
     * 不分页查询发票及关联订单信息
     * @param pageRequest
     * @return
     */
    CommonResponse<List<InvoiceOrderExt>> selectOrderInvoices(CommonRequest<InvoicePageReq> pageRequest);


    /**
     * 更新发票到账状态
     * @param updateRequest
     * @return
     */
    CommonResponse<Boolean> updateArriveStatus(CommonRequest<InvoiceUpdateArriveStatusReq> updateRequest);

    /**
     * 确认是否可以进行发票到账操作
     * @param updateRequest 发票申请单号及发票业务类型
     * @return
     */
    CommonResponse<InvoicePaymentOrderCodeResp> arriveStatusOperationVerify(CommonRequest<InvoiceApplyCodeReq> updateRequest);
}
