package com.roco.settle.api.service;

import com.roco.settle.api.entity.SettlePaymentApply;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.settlepaymentapply.*;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

/**
 * 业务主体支付工单(SettlePaymentApply)表服务接口
 *
 * @author hsf
 * @since 2020-02-25 09:14:36
 */
public interface SettlePaymentApplyService {

    /**
     * 新增数据
     *
     * @param request 实例对象
     * @return 实例对象
     */
    CommonResponse<SettlePaymentApply> saveSettlePaymentApply(CommonRequest<SettlePaymentApplySaveReq> request);

    /**
     * 分页查询
     * @param pageRequest
     * @return
     */
    CommonQueryPageResponse<SettlePaymentApply> pageSettlePaymentApply(CommonQueryPageRequest<SettlePaymentApplyPageReq> pageRequest);


    /**
     * 明细
     *
     * @param request
     * @return
     */
    CommonResponse<SettlePaymentApply> detailSettlePaymentApply(CommonRequest<SettlePaymentApplyDetailReq> request);

    /**
     *
     * 状态更改: 财务确认支付
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> financialPaymentSettlePaymentApply(CommonRequest<SettlePaymentApplyFinancialPaymentReq> request);

    /**
     *
     * 状态更改: 客户收款确认
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> customerReceivedSettlePaymentApply(CommonRequest<SettlePaymentApplyCustomerReceivedReq> request);

    /**
     *
     * 状态更改: 取消
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> cancelSettlePaymentApply(CommonRequest<SettlePaymentApplyCancelReq> request);

}