package com.roco.settle.api.service.policy;

import com.roco.settle.api.entity.policy.PolicyGiftDirectApply;
import com.roco.settle.api.entity.policy.PolicyGiftDirectApplyLog;
import com.roco.settle.api.entity.policy.PolicyGiftDirectDetail;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.policy.*;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.policy.PolicyGiftDirectApplyRes;

public interface PolicyGiftDirectService {

    /**
     * 新增保存PolicyGiftDirectApply
     *
     * @param request
     * @return 保存结果
     */
    CommonResponse<String> saveApply(CommonRequest<PolicyGiftDirectApplyReq> request);

    /**
     * 分页查询保单直投申请单
     *
     * @param request
     * @return
     */
    CommonQueryPageResponse<PolicyGiftDirectApply> pageApplyList(CommonQueryPageRequest<PolicyGiftDirectApplyQueryReq> request);

    /**
     * 获取保单直投申请单明细
     *
     * @param request
     * @return
     */
    CommonResponse<PolicyGiftDirectApplyRes> getApplyInfoByApplyNo(CommonRequest<PolicyGiftDirectApplyReq> request);

    /**
     * 获取保单直投明细列表
     *
     * @param request
     * @return
     */
    CommonQueryPageResponse<PolicyGiftDirectDetail> pageApplyDetailListByApplyNo(CommonQueryPageRequest<PolicyGiftDirectDetailQueryReq> request);

    /**
     * 获取日志
     * @param request
     * @return
     */
    CommonQueryPageResponse<PolicyGiftDirectApplyLog> pageApplyLogList(CommonQueryPageRequest<PolicyGiftDirectApplyLogReq> request);

    /**
     * 提交保单直投申请
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> submitApply(CommonRequest<PolicyGiftDirectApplyReq> request);

    /**
     * 作废保单直投申请
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> invalidApply(CommonRequest<PolicyGiftDirectApplyReq> request);

    /**
     * 处理保单直投申请
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> handleApply(CommonRequest<PolicyGiftDirectApplyReq> request);

    /**
     * 结算保单直投申请
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> settleApply(CommonRequest<PolicyGiftDirectApplyReq> request);

}
