package com.roco.settle.api.service.privatetransfer;

import com.roco.settle.api.entity.privatetransfer.SettlePrivateAttachApplyItem;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.privatetransfer.SettlePrivateAttachApplyItemPaidReq;
import com.roco.settle.api.request.privatetransfer.SettlePrivateAttachApplyItemQueryReq;
import com.roco.settle.api.request.privatetransfer.SettlePrivateAttachApplyItemUpdateStatusReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

import java.util.List;

/**
 * @author hsf
 * @date 2020-02-29 16:33
 */
public interface SettlePrivateAttachApplyItemService {
    /**
     * 明细
     *
     * @param request
     * @return
     */
    CommonResponse<SettlePrivateAttachApplyItem> detail(CommonRequest<SettlePrivateAttachApplyItemQueryReq> request);
    /**
     * 分页
     *
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettlePrivateAttachApplyItem> page(CommonQueryPageRequest<SettlePrivateAttachApplyItemQueryReq> request);

    /**
     * 列表
     *
     * @param request
     * @return
     */
    CommonResponse<List<SettlePrivateAttachApplyItem>> list(CommonRequest<SettlePrivateAttachApplyItemQueryReq> request);

    /**
     *
     * 批量把状态改成已支付
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> paid(CommonRequest<SettlePrivateAttachApplyItemPaidReq> request);


    /**
     * 更新状态
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateStatus(CommonRequest<SettlePrivateAttachApplyItemUpdateStatusReq> request);

}
