package com.roco.settle.api.service.productconfig;

import com.roco.settle.api.entity.productconfig.SettleEnterpriseDefaultGiftTypeConfig;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.productconfig.SettleEnterpriseDefaultGiftTypeConfigBatchEditReq;
import com.roco.settle.api.request.productconfig.SettleEnterpriseDefaultGiftTypeConfigEditReq;
import com.roco.settle.api.request.productconfig.SettleEnterpriseDefaultGiftTypeConfigSearchReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.productconfig.SettleEnterpriseProductInfoResp;

/**
 * @author djt
 * @date 2020/7/20 14:26
 */
public interface SettleEnterpriseDefaultGiftTypeConfigService {

    /**
     * 更新机构默认礼品类型配置
     * @param request
     * @return
     */
    CommonResponse<Boolean> edit(CommonRequest<SettleEnterpriseDefaultGiftTypeConfigEditReq> request);

    /**
     * 批量保存或者更新机构默认礼品类型配置
     * @param request
     * @return
     */
    CommonResponse<Boolean> batchInsertOrUpdate(CommonRequest<SettleEnterpriseDefaultGiftTypeConfigBatchEditReq> request);


    /**
     * 根据机构编码机构默认礼品类型配置
     * @param request
     * @return
     */
    CommonResponse<SettleEnterpriseDefaultGiftTypeConfig> getByEnterpriseCode(CommonRequest<SettleEnterpriseDefaultGiftTypeConfigSearchReq> request);


    /**
     * 根据条件分页查询默认礼品类型配置
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleEnterpriseDefaultGiftTypeConfig> page(CommonQueryPageRequest<SettleEnterpriseDefaultGiftTypeConfigSearchReq> request);


    /**
     * 根据机构编号查询企业可发放产品信息
     * @param request
     * @return
     */
    CommonResponse<SettleEnterpriseProductInfoResp> getEnterpriseProductInfoByEnterpriseCode(CommonRequest<SettleEnterpriseDefaultGiftTypeConfigSearchReq> request);

}
