package com.roco.settle.api.service.productconfig;

import com.roco.settle.api.entity.productconfig.SettleProductPackage;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.productconfig.SettleProductPackageSaveReq;
import com.roco.settle.api.request.productconfig.SettleProductPackageSearchReq;
import com.roco.settle.api.request.productconfig.SettleProductPackageUpdateStatusReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.productconfig.SettleProductPackageDetailExtResp;
import com.roco.settle.api.response.productconfig.SettleProductPackageDetailResp;

import java.util.List;

/**
 * 套餐产品相关接口
 * @author djt
 * @date 2020/7/2 19:05
 */
public interface SettleProductPackageService {

    /**
     * 新增套餐产品
     * @param request
     * @return
     */
    CommonResponse<Boolean> save(CommonRequest<SettleProductPackageSaveReq> request);


    /**
     * 更新套餐产品
     * @param request
     * @return
     */
    CommonResponse<Boolean> update(CommonRequest<SettleProductPackageSaveReq> request);

    /**
     * 分页查询套餐
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleProductPackage> search(CommonQueryPageRequest<SettleProductPackageSearchReq> request);


    /**
     * 更新套餐状态
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateStatus(CommonRequest<SettleProductPackageUpdateStatusReq> request);

    /**
     * 根据套餐编号查询套餐明细
     * @param request
     * @return
     */
    CommonResponse<SettleProductPackageDetailResp> detail(CommonRequest<SettleProductPackageSearchReq> request);


    /**
     * 查询默认套餐
     * @param request
     * @return
     */
    CommonResponse<SettleProductPackageDetailResp> getDefaultPackage(CommonRequest<SettleProductPackageSearchReq> request);


    /**
     * 不分页查询套餐
     * @param request
     * @return
     */
    CommonResponse<List<SettleProductPackage>> all(CommonRequest<SettleProductPackageSearchReq> request);


    /**
     * 根据套餐编号查询套餐明细包括套餐明细产品的默认通道产品编码
     * @param request
     * @return
     */
    CommonResponse<SettleProductPackageDetailExtResp> getDetailByCode(CommonRequest<SettleProductPackageSearchReq> request);

}
