package com.roco.settle.api.service.remittance;

import com.roco.settle.api.entity.remittance.SettleEnterpriseRemittanceOperation;
import com.roco.settle.api.entity.remittance.SettleEnterpriseRemittanceRecord;
import com.roco.settle.api.entity.remittance.SettleEnterpriseRemittanceRecordExt;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.remittance.*;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.remittance.SettleEnterpriseRemittanceRecordRes;

import java.util.List;

/**
 * 业务基点打款工单(SettleEnterpriseRemittanceRecord)表服务接口
 *
 * @author 兰倩
 * @since 2020-02-25 17:55:10
 */
public interface SettleEnterpriseRemittanceRecordService {
    /**
     * 查询单条记录
     * @param  request
     * @return SettleEnterpriseRemittanceRecord
     */
    CommonResponse<SettleEnterpriseRemittanceRecord> get(CommonRequest<BasePrimaryKeyRequest> request);
    /**
     * 查询单条记录
     * @param  request
     * @return SettleEnterpriseRemittanceRecord
     */
    CommonResponse<SettleEnterpriseRemittanceRecordRes> getExt(CommonRequest<BasePrimaryKeyRequest> request);
    /**
     * 查询单条记录
     * @param  request
     * @return SettleEnterpriseRemittanceRecord
     */
    CommonResponse<SettleEnterpriseRemittanceRecordRes> getByCode(CommonRequest<SettleEnterpriseRemittanceRecordReq> request);

    /**
     * 新增保存
     * @param request
     * @return 保存结果
     * */
    CommonResponse<Boolean> save(CommonRequest<SettleEnterpriseRemittanceRecordSaveReq> request);
    /**
     * 更新记录
     * @param request
     * @return 更新结果
     * */
    CommonResponse<Boolean> update(CommonRequest<SettleEnterpriseRemittanceRecordUpdateReq>request);

    /**
     * 提交
     * */
    CommonResponse<Boolean> submit(CommonRequest<BasePrimaryKeyRequest>request);
    /**
     * 删除
     * @param request
     * @return 删除结果
     * */
    CommonResponse<Boolean> deleteById(CommonRequest<BasePrimaryKeyRequest>  request);
    /**
     * 确认
     * @param request {id, confirmDate}
     * @return
     * */
    CommonResponse<String> confirm(CommonRequest<SettleEnterpriseRemittanceRecordReq>  request);
    /**
     * 取消
     * @param request
     * @return
     * */
    CommonResponse<Boolean> cancel(CommonRequest<BasePrimaryKeyRequest>  request);

    /**
     *支付确认
     * @param request
     * @return
     * */
    CommonResponse<Boolean> pay(CommonRequest<SettleEnterpriseRemittanceRecordPayReq>  request);
    /**
     * 收款确认
     * @param request
     * @return
     * */
    CommonResponse<Boolean> receipt(CommonRequest<SettleEnterpriseRemittanceRecordReceiptReq>  request);
    /**
     * 列表-分页
     * @param request 关键字
     * @return 分页查询实体
     */
    CommonQueryPageResponse<SettleEnterpriseRemittanceRecordExt> search(CommonQueryPageRequest<SettleEnterpriseRemittanceRecordPageReq> request);

    /**
     * 查询全部
     * @param request
     * @return 查询实体
     */
    CommonResponse<List<SettleEnterpriseRemittanceRecordExt>> all(CommonRequest<SettleEnterpriseRemittanceRecordPageReq> request);

    /**
     * 查询操作日志
     * */
     CommonQueryPageResponse<SettleEnterpriseRemittanceOperation> searchOperation(CommonQueryPageRequest<SettleEnterpriseRemittanceOperationPageReq> request);
}