package com.roco.order.api.entity;

import java.time.LocalDateTime;

import com.roco.order.api.enums.MqCustomerStatus;
import com.roco.order.api.enums.OrderMqTypeEnum;
import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 订单MQ消费(OrderMqCustomer)实体类
 *
 * @author hsf
 * @since 2020-03-20 11:39:04
 */
@Data
@Table(name = "order_mq_customer")
public class OrderMqCustomer implements Serializable {

   
    @Id
    private Long id;

    /**
     * 类型(ORDER_OIL_CARD-油卡订单同步,ORDER_PUBLIC-对公转账订单,ORDER_PRIVATE-对私转账订单)  
     */
    private OrderMqTypeEnum type;

    private String exchange;

    private String routeKey;

    /**
     * 消息主体  
     */
    private String message;

    /**
     * 状态(INIT-初始化,SUCCESS-成功,FAIL-失败)  
     */
    private MqCustomerStatus status;

    /**
     * 备注  
     */
    private String remark;

    /**
     * 消费信息重复性  
     */
    private String md5sum;

    /**
     * 创建时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

   

}