package com.roco.settle.api.entity.billing;

import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 业务主体开票工单-发票关联(SettleSubjectBillingReferenceInvoice)实体类
 *
 * @author 兰倩
 * @since 2020-02-25 17:41:44
 */
@Data
@Table(name = "settle_subject_billing_reference_invoice")
public class SettleSubjectBillingReferenceInvoice implements Serializable {

   
    @Id
    private Long id;

    /**
     * 开票工单号  
     */
    private String billingCode;

    /**
     * 发票入库申请单号  
     */
    private String invoiceApplyCode;

    /**
     * 创建时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人  
     */
    private Long createUser;

    /**
     * 创建姓名  
     */
    private String createName;

    /**
     * 创建类型  
     */
    private String createUsertype;

    /**
     * 状态(1已使用，0已释放)  
     */
    private Integer status;

    /**
     * 寄送信息编码  
     */
    private String sendCode;
    /**
     * 发票号码
     * */

    private String invoiceCode;

   

}