package com.roco.settle.api.entity.enterprisetansfer;

import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 对公转账清单(SettleEnterpriseTransferItem)实体类
 *
 * @author Andrew
 * @since 2020-02-24 11:53:00
 */
@Data
@Table(name = "settle_enterprise_transfer_item")
public class SettleEnterpriseTransferItem implements Serializable {

   
    @Id
    private Long id;

    /**
     * 申请单号  
     */
    private String applyNo;

    /**
     * 服务清单编号  
     */
    private String serviceItemNo;

    /**
     * 备注  
     */
    private String remark;

    /**
     * 创建时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

   

}