package com.roco.settle.api.entity.productconfig;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Id;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/3/23 15:43</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
public class SettleEnterpriseProduct implements Serializable {
    /**
     * 机构商品配置编码
     */
    @Id
    private String code;

    /**
     * 机构编码
     */
    private String enterpriseCode;

    /**
     * 机构简称
     */
    private String simpleName;

    /**
     * 商品编码
     */
    private String productCode;

    /**
     * 商品名称
     */
    private String productName;
    /**
     * 商品类型编码
     */
    private String productTypeCode;
    /**
     * 商品类型名称
     */
    private String productTypeName;
    /**
     * 品牌名称
     */
    private String brandName;
    /**
     * 品牌编码
     */
    private String brandCode;
    /**
     * 面值
     */
    private BigDecimal faceValue;
    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 供应商编码
     */
    private String supplierCode;
    /**
     * 结算模式
     */
    private String settleModel;
    /**
     * 采购价
     */
    private BigDecimal purchasePrice;
    /**
     * 销售价
     */
    private BigDecimal sellPrice;
    /**
     * 商品状态
     */
    private Integer productStatus;

    /**
     * 更新人id
     */
    private Integer updateUser;

    /**
     * 更新人名称
     */
    private String updateName;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 推放服务系数
     */
    private BigDecimal psfRatio;

    /**
     * 人保机构号
     */
    private String piccOrgCode;


}