package com.roco.settle.api.entity.supplier;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/5/1 10:29</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@Table(name = "sc_supplier_api_config")
public class SupplierApiConfig implements Serializable {
    @Id
    private Long id;

    /**
     * 供应商编号(sc_supplier.supplier_no)
     */
    private String supplierNo;

    /**
     * 上游对接系统app id
     */
    private String appId;

    /**
     * 上游对接系统app secret
     */
    private String appSecret;

    /**
     * 上游对接系统公钥
     */
    private String publicKey;

    /**
     * 根url
     */
    private String url;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private Long createUser;

    private String createUsertype;

    private String createName;
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    private Long updateUser;

    /**
     *  
     */
    private String updateName;

    private String updateUsertype;
    
}