package com.roco.settle.api.enums;

import lombok.Getter;


/**
 * @author Andrew
 * @create 2020/2/4 8:58 下午
 */
public enum ResponseEnum {
    /**
     * 成功
     */
    SUCCESS("000000","成功"),

    /**
     * 无操作权限
     */
    AUTH_ERROR("400001", "无操作权限"),
    /**
     * 参数错误
     */
    PARAM_ERROR("500001", "参数异常"),

    DUPLICATE_ERROR("500002", "数据重复异常"),

    BIZ_ERROR("500003", "业务异常"),
    /**
     * 系统异常
      */
    SYSTEM_ERROR("999999","系统异常");

    ResponseEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Getter
    private String code;

    @Getter
    private String message;

    public static boolean isSuccess(String retCode){
        if (retCode != null && SUCCESS.getCode().equals(retCode)) {
            return true;
        }
        return false;
    }
}
