package com.roco.settle.api.enums.order.payment;


import lombok.Getter;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 供应商订单操作类型枚举
 * @author dongjuntong
 */
public enum PaymentOrderOperationTypeEnum {



    /**
     * 创建
     */
    CREATE(new PaymentOrderStatusEnum[]{ PaymentOrderStatusEnum.EMPTY} ,
            PaymentOrderStatusEnum.WAIT_HANDLE),

    /**
     * 处理
     */
    HANDLE(new PaymentOrderStatusEnum[]{PaymentOrderStatusEnum.WAIT_HANDLE},
            PaymentOrderStatusEnum.HANDLING),

    /**
     * 编辑发票credential
     */
    EDIT_CREDENTIAL(new PaymentOrderStatusEnum[]{PaymentOrderStatusEnum.WAIT_HANDLE},
            PaymentOrderStatusEnum.WAIT_HANDLE),


    /**
     * 处理完毕
     */
    FINISH(new PaymentOrderStatusEnum[]{PaymentOrderStatusEnum.HANDLING},
            PaymentOrderStatusEnum.FINISH),


    /**
     *取消
     */
    CANCEL(new PaymentOrderStatusEnum[]{PaymentOrderStatusEnum.HANDLING,PaymentOrderStatusEnum.WAIT_HANDLE},
            PaymentOrderStatusEnum.CANCEL
            );


    @Getter
    private PaymentOrderStatusEnum[] before ;

    @Getter
    private PaymentOrderStatusEnum after ;

    public List<String> getBefore(){
        return Stream.of(before).map(PaymentOrderStatusEnum::name).collect(Collectors.toList());
    }

    public String getAfter(){
        return this.after.name();
    }

    PaymentOrderOperationTypeEnum(PaymentOrderStatusEnum[] before,PaymentOrderStatusEnum after){
        this.before = before;
        this.after = after;
    }

}
