package com.roco.settle.api.request.billing;

import com.roco.settle.api.enums.billing.SettleSubjectBillingStatusEnum;
import lombok.Data;
import java.io.Serializable;

/**
 * @author lanqian
 */
@Data
public class SettleSubjectBillingRecordReq implements Serializable {

    private Long id;

    /**
     * 业务主体开票工单号
     */
    private String code;

    /**
     * 关联打款工单
     */
    private String remittanceCode;
    /**
     * 状态
     */
    private SettleSubjectBillingStatusEnum status;

    /**
     * 逻辑删除（0：未删除，1：已删除）
     */
    private Integer deleted;

    /**
     * 业务主体编码
     */
    private String bizSubjectCode;

    /**
     * 业务主体简称
     */
    private String bizSubjectSimpleName;

    /**
     * 机构编码(业务基点)
     */
    private String enterpriseCode;

    /**
     * 机构简称（业务基点）
     */
    private String enterpriseSimpleName;

    /**
     * 人保机构号
     */
    private String piccOrgCode;
}
