package com.roco.settle.api.request.invoice;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.entity.invoice.Invoice;
import com.roco.settle.api.enums.invoice.*;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class InvoiceSaveReq implements Serializable {

    /**
     * id
     */
    private Long id;

    /**
     * 入库申请单号
     */
    private String applyCode;

    /**
     * 开票主体类型 业务主体:BIZ_SUBJECT 供应商:SUPPLIER
     */
    @NotNull(message = "开票主体类型不能为空")
    private InvoiceSubjectTypeEnum invoiceSubjectType;

    /**
     * 发票性质
     */
    @Pattern(regexp = "^(BJROCO_BASE_POINT|GZROCO_BASE_POINT|SUPPLIER_BJROCO|SUPPLIER_GZROCO)$",message = "发票性质参数不匹配")
    private String invoiceNature;

    /**
     * 业务主体编码
     */
    @NotBlank(message = "业务主体编码不能为空")
    private String bizSubjectCode;

    /**
     * 业务主体简称
     */
    @NotBlank(message = "业务主体简称不能为空")
    private String bizSubjectSimpleName;

    /**
     * 业务基点编码
     */
    private String basePointCode;

    /**
     * 业务基点简称
     */
    private String basePointSimpleName;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 供应商名称
     */
    private String supplierSimpleName;


    /**
     * 发票号码
     */
    @NotBlank(message = "发票号码不能为空")
    private String invoiceCode;

    /**
     * 发票代码
     */
    @NotBlank(message = "发票代码不能为空")
    private String invoiceNo;

    /**
     * 发票类型   增值税专用发票：DEDICATED ，增值税普通发票：NORMAL
     */
    @Pattern(regexp = ("^(DEDICATED|NORMAL)$"),message = "发票类型参数不匹配")
    private String invoiceType;

    /**
     * 发票保存地址
     */
    private String invoiceUrl;

    /**
     * 发票金额
     */
    @NotNull(message = "发票金额不能为空")
    private BigDecimal invoiceAccount;

    /**
     * 税率
     */
    @NotNull(message = "发票税率不能为空")
    private BigDecimal taxRate;

    /**
     * 税额
     */
    @NotNull(message = "发票税额不能为空")
    private BigDecimal tax;

    /**
     * 发票含税金额
     */
    @NotNull(message = "发票含税金额不能为空")
    private BigDecimal taxAccount;

    /**
     * 付款方
     */
    @NotBlank(message = "付款方不能为空")
    private String payer;

    /**
     * 收款方
     */
    @NotBlank(message = "收款方不能为空")
    private String payee;

    /**
     * 开票日期
     */
    @NotNull(message = "开票日期不能为空")
    private String billingDate;

    /**
     * 申请状态 草稿：DRAFT 待确认: UNCONFIRMED 已入库: CONFIRMED
     */
    private InvoiceStatusEnum status;

    /**
     * 备注
     */
    private String remark;

}
