package com.roco.settle.api.request.invoice;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.invoice.InvoiceOperationTypeEnum;
import com.roco.settle.api.request.base.FileRes;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * @author dongjuntong
 * @create 2020/2/6 15:35
 */
@Data
public class InvoiceUpdateArriveStatusReq implements Serializable {


    /**
     * 发票入库申请单号
     */
    @NotNull(message = "发票code不能为空")
    private String Code;


    /**
     * 发票真实到账日期
     */
    @NotNull(message = "发票真实到账日期不能为空")
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate arriveDate;

    /**
     * 发票文件
     */
    @NotNull(message = "至少上传一个凭证")
    @Size(min = 1,message = "至少上次一个凭证")
    private List<FileRes> reses;


    /**
     * 关联支付工单或者打款工单编号
     */
    @NotBlank(message = "该发票尚未关联支付工单或者打款工单")
    private  String paymentOrderCode;
    /**
     * 备注
     */
    private String remark;
}
