package com.roco.settle.api.request.remittance;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.IsEnum;
import com.roco.settle.api.enums.remittance.SettleEnterpriseRemittanceCapitalTypeEnum;
import com.roco.settle.api.enums.remittance.SettleEnterpriseRemittanceStatusEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 业务基点打款工单(SettleEnterpriseRemittanceRecord)请求实体类
 *
 * @author 兰倩
 * @since 2020-02-25 17:24:25
 */
@Data
public class SettleEnterpriseRemittanceRecordUpdateReq implements Serializable {
    @NotNull(message = "业务基点打款主键不可为空")
    private Long id;

    /**
     * 业务基点打款工单号  
     */
    @NotBlank(message = "业务基点打款工单号不可为空")
    private String code;

    /**
     * 状态  
     */
    @NotNull(message = "业务基点打款工单状态不可为空")
    private SettleEnterpriseRemittanceStatusEnum status;

    /**
     * 逻辑删除（0：未删除，1：已删除）  
     */
    private Integer deleted;

    /**
     * 业务主体编码  
     */
    @NotBlank(message = "业务主体不可为空")
    private String bizSubjectCode;

    /**
     * 业务主体简称  
     */
    private String bizSubjectSimpleName;

    /**
     * 机构编码(业务基点)  
     */
    @NotBlank(message = "业务基点不可为空")
    private String enterpriseCode;

    /**
     * 机构简称（业务基点）  
     */
    private String enterpriseSimpleName;

    /**
     * 人保机构号  
     */
    private String piccOrgCode;

    /**是否人保机构
     * */
    private  Long isPicc;

    /**
     * 工单名称  
     */
    @NotBlank(message = "工单名称不可为空")
    private String name;

    /**
     * 工单说明  
     */
    private String introduction;

    /**
     * 工单类型  
     */
    private String  type;

    /**
     * 打款金额  
     */
    @DecimalMin(value = "0.01",message = "打款金额不可为空")
    @Digits(integer = 10, fraction = 2, message = "最多两位小数")
    private BigDecimal remittanceAmount;

    /**
     * 资金性质  
     */
    @NotNull(message = "资金性质不可为空")
    private SettleEnterpriseRemittanceCapitalTypeEnum capitalType;

    /**
     * 是否附带服务清单
     * */
    @NotNull(message = "是否附带服务清单不可为空")
    private IsEnum haveServiceApply;

    /**
     * 服务清单申请单编码  
     */
  //  @NotBlank(message = "服务清单申请单号不可为空")
    private String serviceApplyCode;

    /**
     * 清单总笔数  
     */
    private Long serviceTotalCnt;

    /**
     * 清单总金额  
     */
    private BigDecimal serviceTotalAmount;

    /**
     * 业务基点提供附件日期  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate serviceProvideDate;

    /**
     * * 上传的新文件
     * */
    private List<SettleEnterpriseRemittanceFileSaveReq> settleEnterpriseRemittanceFileSaveReqList;
    /**
     * 删除的附件id
     * */
    private List<Long> deletedFileIds;
}