package com.roco.settle.api.request.supplier.supplychain.apiconfig;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 供应商上游API配置
 * @author lanqian
 */
@Data
public class SupplierApiConfigSaveReq implements Serializable {

    private Long id;

    /**
     * 供应商编号(sc_supplier.supplier_no)
     */
    @NotBlank(message = "供应商编号不可为空！")
    private String supplierNo;

    /**
     * 上游对接系统app id
     */
    @NotBlank(message = "上游对接系统appid不可为空！")
    private String appId;

    /**
     * 上游对接系统app secret
     */
    @NotBlank(message = "上游对接系统appsecret不可为空！")
    private String appSecret;

    /**
     * 上游对接系统公钥
     */
    @NotBlank(message = "上游对接系统公钥不可为空！")
    private String publicKey;

    /**
     * 根url
     */
    @NotBlank(message = "url不可为空！")
    private String url;
}
