package com.rocogz.syy.equity.entity.coupon;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.equity.entity.couponType.EquityCouponType;
import jdk.nashorn.internal.ir.annotations.Ignore;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 优惠券基本信息 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-06 12:13:09</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_coupon_info")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityCouponInfo extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 自动发券编号
     */
    private String autoCode;

    /**
     * 优惠券编号
     */
    @Ignore
    private String code;

    /**
     * 优惠券名称
     */
    private String name;

    /**
     * 优惠券类型编号
     */
    private String typeCode;

    /**
     * 优惠券状态（草稿、待审批、审批通过、审批不通过、审批打回、待上架、上架、下架）
     */
    private String status;

    /**
     * 优惠券使用说明
     */
    private String description;

    /**
     * 优惠券使用说明图片url
     */
    private String img;

    /**
     * 优惠券类型信息
     */
    @TableField(exist = false)
    private EquityCouponType couponType;

    /**
     * 优惠券使用信息
     */
    @TableField(exist = false)
    private EquityCouponUseInfo useInfo;

    /**
     * 优惠券投放信息
     */
    @TableField(exist = false)
    private EquityCouponLaunchInfo launchInfo;

    /**
     * 优惠券专区项目关系
     */
    @TableField(exist = false)
    private EquityCouponAreaProjectRel areaProjectRel;

    /**
     * 优惠券专区关系（可用/不可用）
     */
    @TableField(exist = false)
    private List<EquityCouponAvailableAreaRel> availableAreaRelList;

    /**
     * 优惠券门店关系（可用/不可用）
     */
    @TableField(exist = false)
    private List<EquityCouponStoreRel> storeRelList;

    /**
     * 优惠券投放主体关系
     */
    @TableField(exist = false)
    private List<EquityCouponSourceRel> sourceRelList;


    /**
     * 优惠券标签关系
     */
    @TableField(exist = false)
    private List<EquityCouponLabelRel> labelRelList;

    /**
     * 代金券金额、折扣率相关
     */
    @TableField(exist = false)
    private EquityCashCouponAmount cashAmount;

    /**
     * 代金券可用商品
     */
    @TableField(exist = false)
    private List<EquityCashCouponProduct> cashAvailableProduct;

}
