package com.rocogz.dto.coupon;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 兑换码导出总行数请求参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022-03-30 09:24:16</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class EquityRedeemReqParamDto {

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 优惠券名称
     */
    private String couponName;

    /**
     * 状态:PENDING-待生成，IN_PROCESS-生成中，FAIL-失败，SOME_FAIL-部分失败，SUCCESS-完成，CANCEL-作废
     */
    private String status;

    /**
     * 兑换码
     */
    private String redeemCode;

    /**
     * 每页记录数
     */
    private Integer limit = 20;

    /**
     * 页码
     */
    private Integer page = 1;

}
