package com.rocogz.syy.equity.entity.coupon;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: 代金券商品相关 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-06-17 17:50:36</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_cash_coupon_product")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityCashCouponProduct extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 商品编号
     */
    private String productCode;

    /**
     * 商品名称
     */
    private String productName;

    /**
     * 商品价格
     */
    private BigDecimal productPrice;


}
