package com.rocogz.entity.coupon;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 优惠券操作日志 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2022-03-15 13:36:57</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_coupon_log")
public class EquityCouponLog extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 操作类型：EDIT-编辑，TO_LIST-上架，DEL_LIST-下架，CANCEL-作废，DELETE-删除
     */
    private String type;

    /**
     * 操作内容
     */
    private String rmk;

}
