package com.rocogz;

import com.rocogz.util.DateUtil;
import com.rocogz.util.des.MD5;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 权益工具类 </dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-05-12 08:48:46</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
public class EquityCommonUtil {

    /**
     * 生成兑换码
     * @param code   编号
     * @return
     */
    public static String generateRedeemCode(String code){
        final double d = Math.random();
        final int i = (int)(d * 100);
        String md5Str = MD5.MD5(code + String.valueOf(i)) ;
        return md5Str.substring(8, 24);
    }

    /**
     * 根据生效、失效日期转换状态
     * @param effectiveDate 生效日期
     * @param invalidDate   失效日期
     * @return
     */
    public static String convertStatusByEffectiveInvalidDate(LocalDateTime effectiveDate, LocalDateTime invalidDate){
        int statusCode = DateUtil.dateStatus(DateUtil.formatLocalDateTimeToString(effectiveDate), DateUtil.formatLocalDateTimeToString(invalidDate));
        return statusCode == 0 ? EquityConstants.CouponInfoConstants.REDEEM_STATUS_UN_EFFECTIVE : statusCode == 1 ? EquityConstants.CouponInfoConstants.REDEEM_STATUS_NORMAL : EquityConstants.CouponInfoConstants.REDEEM_STATUS_INVALID;
    }

    /**
     * 获取日期
     * @param model 模式
     * @param modeVal 值
     * @param type E:生效, I:失效
     * @param pointDate 此参数只有在type为I的时候传入生效日期，type为E的时候不需要传。
     *                  type=I时，需要根据生效日期计算失效日期，所以此参数必传
     * @return
     */
    public static LocalDateTime getEffectiveInvalidDateByMode(String model, String modeVal, String type, LocalDate pointDate){
        LocalDateTime localDateTime = null;
        if(EquityConstants.CouponInfoConstants.COUPON_DATE_MODE_POINT_DATE.equals(model)){ //指定日期
            localDateTime = DateUtil.formatDateStrToLocalDateTime(modeVal + ("E".equals(type) ? DateUtil.START_TIME : DateUtil.END_TIME ));
        }else if(EquityConstants.CouponInfoConstants.COUPON_DATE_MODE_GENERATE.equals(model) || EquityConstants.CouponInfoConstants.COUPON_DATE_MODE_LATER_DAY.equals(model)){//生成时生效、生效后XX天失效
            localDateTime = DateUtil.formatDateStrToLocalDateTime(pointDate.plusDays(Long.valueOf(modeVal)) + (type == "E" ? DateUtil.START_TIME : DateUtil.END_TIME));
        }
        return localDateTime;
    }

//
//    /**
//     *  根据订单失效期方式、订单失效期值、用户券失效日期计算订单失效日期
//     * @param orderInvalidModel 订单失效期方式
//     * @param orderInvalidValue 订单失效期值
//     * @param userCouponInvalidDate 用户券失效日期
//     * @return
//     */
//    public static LocalDateTime getOrderInvalidDate(String orderInvalidModel, String orderInvalidValue, LocalDateTime userCouponInvalidDate){
//        if(EquityConstants.COUPON_LAUNCH_INFO_COUPON_LAST_DAY_INVALID.equals(orderInvalidModel)){ //优惠券失效日期XX天后失效
//            return userCouponInvalidDate.plusDays(Long.valueOf(orderInvalidValue));
//        }
//        return userCouponInvalidDate;
//    }
}
