package com.rocogz.entity.coupon;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 优惠券兑换码 entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2022-03-15 13:36:57</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_coupon_redeem")
public class EquityCouponRedeem extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 优惠券名称
     */
    @TableField(exist = false)
    private String couponName;

    /**
     * 折扣率
     */
    @TableField(exist = false)
    private BigDecimal discount;

    /**
     * 兑换码生成源
     */
    private String sourceToRedeem;

    /**
     * 兑换码
     */
    private String redeemCode;

    /**
     * 生效日期
     */
    private LocalDateTime effectiveDate;

    /**
     * 失效日期
     */
    private LocalDateTime invalidDate;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 用户号
     */
    private String userCode;

    /**
     * sku商品编号
     */
    private String skuGoodsCode;

    @TableField(exist = false)
    private String skuGoodsName;

    /**
     * 状态：UN_EFFECTIVE-待生效，NORMAL-待使用，USED-已使用，INVALID-已过期，CANCEL-已作废
     */
    private String status;

    /**
     * 使用时间
     */
    private LocalDateTime useTime;

}
