package com.rocogz;

/**
 * <dl>
 * <dd>Description: 权益常量类 Service</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2022-03-15 13:58:34</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
public final class EquityConstants {

	private EquityConstants() {
	}

	/** 公共常量 - 待上架、待生成 **/
	public static final String COMMON_STATUS_PENDING = "PENDING";

	/** 公共常量 - 失败 **/
	public static final String COMMON_STATUS_FAIL = "FAIL";

	/** 公共常量 - 部分失败 **/
	public static final String COMMON_STATUS_SOME_FAIL = "SOME_FAIL";

	/** 公共常量 - 作废 **/
	public static final String COMMON_STATUS_CANCEL = "CANCEL";

	/** 批量插入行数 **/
	public static final Integer BATCH_INSERT_ROW = 3000;

	/**
	 * 优惠券常量相关
	 */
	public static class CouponInfoConstants {

		/** 优惠券日期模式 - 指定日期生效、失效 **/
		public static final String COUPON_DATE_MODE_POINT_DATE = "POINT_DATE";
		/** 优惠券日期模式 - 生成时生效、失效 **/
		public static final String COUPON_DATE_MODE_GENERATE = "GENERATE";
		/** 优惠券日期模式 - 生效后XX天失效 **/
		public static final String COUPON_DATE_MODE_LATER_DAY = "LATER_DAY";

		/** 优惠券状态 - 上架 **/
		public static final String COUPON_STATUS_TO_LIST = "TO_LIST";
		/** 优惠券状态 - 下架 **/
		public static final String COUPON_STATUS_DEL_LIST = "DEL_LIST";
		/** 优惠券状态 - 删除 **/
		public static final String COUPON_STATUS_DELETE = "DELETE";

		/** 优惠券操作日志操作状态 - 编辑 **/
		public static final String COUPON_STATUS_EDIT = "EDIT";

		/** 兑换码状态 - 待生效 **/
		public static final String REDEEM_STATUS_UN_EFFECTIVE = "UN_EFFECTIVE";
		/** 兑换码状态 - 待使用 **/
		public static final String REDEEM_STATUS_NORMAL = "NORMAL";
		/** 兑换码状态 - 已失效 **/
		public static final String REDEEM_STATUS_INVALID = "INVALID";
		/** 兑换码状态 - 已使用 **/
		public static final String REDEEM_STATUS_USED = "USED";

		/** 兑换码生成记录状态 - 生成中 **/
		public static final String REDEEM_RECORD_STATUS_IN_PROCESS = "IN_PROCESS";
		/** 兑换码生成记录状态 - 完成 **/
		public static final String REDEEM_RECORD_STATUS_SUCCESS = "SUCCESS";

		/** 优惠券 - 发号器编号 **/
		public static final String COUPON_CODE_KEY = "COUPON_CODE";
		/** 批次号 - 发号器编号 **/
		public static final String BATCH_NO_KEY = "REDEEM_BATCH_NO";
	}

}
