package com.rocogz.client;

import com.rocogz.dto.coupon.*;
import com.rocogz.entity.coupon.EquityCouponInfo;
import com.rocogz.entity.coupon.EquityCouponLog;
import com.rocogz.entity.coupon.EquityCouponRedeem;
import com.rocogz.entity.coupon.EquityCouponRedeemRecord;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 权益服务对外接口 service</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2020-04-05 20:08:42</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
public interface IEquityClientService {

    /**
     * 新增、编辑
     * @return
     */
    @PostMapping("/api/equity/couponInfo/saveOrUpdate")
    Response insertOrUpdate(@RequestBody EquityCouponInfo entity);

    /**
     * 查询
     * @return
     */
    @PostMapping("/api/equity/couponInfo/searchCouponInfo")
    PageTable<EquityCouponInfo> searchCouponInfo(@RequestBody EquityCouponSearchParamDto paramDto);

    /**
     * 根据编号查询优惠券信息
     * @param code  优惠券编号
     * @return
     */
    @GetMapping("/api/equity/couponInfo/getCouponByCode")
    Response<EquityCouponInfo> getCouponByCode(@RequestParam(value = "code") String code);

    /**
     * 待上架
     * @param paramDto 请求参数
     * @return
     */
    @PostMapping("/api/equity/couponInfo/pending")
    Response pending(@Validated @RequestBody EquityCouponUpdateStatusParamDto paramDto);

    /**
     * 上架
     * @param paramDto 请求参数
     * @return
     */
    @PostMapping("/api/equity/couponInfo/toList")
    Response toList(@Validated @RequestBody EquityCouponUpdateStatusParamDto paramDto);

    /**
     * 下架
     * @param paramDto 请求参数
     * @return
     */
    @PostMapping("/api/equity/couponInfo/delList")
    Response delList(@Validated @RequestBody EquityCouponUpdateStatusParamDto paramDto);

    /**
     * 作废
     * @param paramDto 请求参数
     * @return
     */
    @PostMapping("/api/equity/couponInfo/cancel")
    Response cancel(@Validated @RequestBody EquityCouponUpdateStatusParamDto paramDto);

    /**
     * 删除
     * @param paramDto 请求参数
     * @return
     */
    @PostMapping("/api/equity/couponInfo/delete")
    Response delete(@Validated @RequestBody EquityCouponUpdateStatusParamDto paramDto);

    /**
     * 查询
     * @return
     */
    @PostMapping("/api/equity/couponLog/searchCouponLog")
    PageTable<EquityCouponLog> searchCouponLog(@RequestParam(value = "couponCode") String couponCode,
                                                       @RequestParam(value = "page", defaultValue = "1") int page,
                                                       @RequestParam(value = "limit", defaultValue = "20") int limit);

    /**
     * 查询
     * @param paramDto 请求参数
     * @return
     */
    @PostMapping("/api/equity/couponRedeem/searchRedeem")
    PageTable<EquityCouponRedeem> searchRedeem(@RequestBody EquityRedeemReqParamDto paramDto);

    /**
     * 统计导出总行数
     * @param paramDto  请求参数
     * @return
     */
    @PostMapping("/api/equity/couponRedeem/countExportTotalRow")
    Integer countExportTotalRow(@RequestBody EquityRedeemReqParamDto paramDto);

    /**
     * 导出
     * @param paramDto
     * @return
     */
    @PostMapping("/api/equity/couponRedeem/exportData")
    Response<List<EquityRedeemExportResultDto>> exportData(@RequestBody EquityRedeemReqParamDto paramDto);

    /**
     * 根据兑换码作废
     * @param redeemCode    兑换码
     * @param operateUser   操作用户
     * @return
     */
    @GetMapping("/api/equity/couponRedeem/cancelRedeemCode")
    Response cancelRedeemCode(@RequestParam(value = "redeemCode") String redeemCode,
                                       @RequestParam(value = "operateUser") String operateUser);


    /**
     * 保存兑换码生成记录
     * @param entity
     * @return
     */
    @PostMapping("/api/equity/couponRedeemRecord/saveRedeemRecord")
    Response saveRedeemRecord(@RequestBody EquityCouponRedeemRecord entity);

    /**
     * 查询
     * @param paramDto 请求参数
     * @return
     */
    @PostMapping("/api/equity/couponRedeemRecord/searchRedeemRecord")
    PageTable<EquityRedeemRecordResultDto> searchRedeemRecord(@RequestBody EquityCouponSearchParamDto paramDto);

    /**
     * 兑换生成记录详情
     * @param batchNo   批次号
     * @return
     */
    @GetMapping("/api/equity/couponRedeemRecord/redeemRecordDetail")
    Response<EquityCouponRedeemRecord> redeemRecordDetail(@RequestParam(value = "batchNo") String batchNo);

    /**
     * 立即生成
     * @param batchNo       批次号
     * @param couponCode    优惠券编号
     * @param isAgain       是否再次处理
     * @param operateUser   操作人
     * @return
     */
    @GetMapping("/api/equity/couponRedeemRecord/generateNow")
    Response generateNow(@RequestParam(value = "batchNo") String batchNo,
                         @RequestParam(value = "couponCode") String couponCode,
                                @RequestParam(value = "isAgain") boolean isAgain,
                                @RequestParam(value = "operateUser") String operateUser);

    /**
     * 作废
     * @param batchNo       批次号
     * @param operateUser   操作人
     * @return
     */
    @GetMapping("/api/equity/couponRedeemRecord/cancelRedeemRecord")
    Response cancelRedeemRecord(@RequestParam(value = "batchNo") String batchNo,
                           @RequestParam(value = "operateUser") String operateUser);


    /**
     * 根据兑换码、sku商品编号查询优惠券信息，车主聚合下单时调用
     * @param redeemCode         兑换码
     * @param skuGoodsCode       sku商品编号
     * @return
     */
    @GetMapping("/api/equity/couponInfo/getCouponByRedeemCode")
    Response<EquityRedeemInfoForCarownerResultDto> getCouponByRedeemCode(@RequestParam(value = "redeemCode") String redeemCode,
                                                                                @RequestParam(value = "skuGoodsCode") String skuGoodsCode);

    /**
     * 兑换码使用
     * @param entity
     * @return
     */
    @PostMapping("/api/equity/couponRedeem/consumeByRedeemCode")
    Response consumeByRedeemCode(@Validated @RequestBody EquityRedeemCodeConsumeParamDto entity);

    /**
     * 兑换码退回
     * @param entity
     * @return
     */
    @PostMapping("/api/equity/couponRedeem/redeemCodeBack")
    Response redeemCodeBack(@Validated @RequestBody EquityRedeemCodeConsumeParamDto entity);

    /**
     * 根据生效、失效时间将已过期的兑换码更新过期
     * @return
     */
    @GetMapping("/api/equity/couponRedeem/redeemCodeToInvalidByEffectiveInvalidDate")
    Response redeemCodeToInvalidByEffectiveInvalidDate();

}