package com.rocogz.dto.coupon;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 兑换码生成记录结果 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022-03-29 14:32:33</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class EquityRedeemRecordResultDto {

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 优惠券名称
     */
    private String couponName;

    /**
     * 折扣率
     */
    private BigDecimal discount;

    /**
     * 生成数量
     */
    private Integer quantity;

    /**
     * 状态:PENDING-待生成，IN_PROCESS-生成中，FAIL-失败，SOME_FAIL-部分失败，SUCCESS-完成，CANCEL-作废
     */
    private String status;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;
}
