package com.rocogz.syy.infrastructure.dto.samsung.resp;

import lombok.Data;

import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 会员信息查询响应 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-11-10 15:53:38</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class MemberInfoQueryRespDto{

    /**
     * 会员ID
     */
    private String memberShipId;

    /**
     * 姓名
     */
    private String fullName;

    /**
     * 电话号
     */
    private String phone;

    /**
     * 电子邮箱
     */
    private String email;

    /**
     * 省市区
     */
    private String address1;

    /**
     * 详细住址
     */
    private String address2;

    /**
     * 性别：F-女性 M-男性
     */
    private String sex;

    /**
     * 生日
     */
    private LocalDateTime birthDay;

    /**
     * 证件类型：SOCL-身份证 PASS-护照 CAR-军官证
     */
    private String idType;

    /**
     * 证件号码（密文）
     */
    private String identityId;

    /**
     * A:激活, D:删除, I:非激活, L:锁定
     */
    private String status;

    /**
     * N-同意 Y-不同意
     */
    private String agreeSms;

    /**
     * 日期
     */
    private String agreeSmsDate;

    /**
     * N-同意 Y-不同意
     */
    private String agreeMarketing;

    /**
     * N-同意 Y-不同意
     */
    private String agreeSaPush;

    /**
     * 会员等级
     */
    private String zLevel;

    /**
     * 注册渠道
     */
    private String channel;

    /**
     * 注册日期
     */
    private LocalDateTime regDate;

    /**
     * 证件审核通过日期
     */
    private LocalDateTime appDate;

    /**
     * 注册门店/区域
     */
    private String regLocation;

    /**
     * 注册人
     */
    private String salesId;

    /**
     * 微信Union ID
     */
    private String wechatUnionId;

    /**
     * 支付宝Union ID
     */
    private String aliPayUnionId;

    /**
     * 资和信卡 BASE64加密
     */
    private String zhxId;

    /**
     * SA ID
     */
    private String saId;

    /**
     * SA GUID
     */
    private String saGuid;

    /**
     * 是否有管家服务
     */
    private String butlerService;

    /**
     * 管家服务开始时间
     */
    private LocalDateTime butlerFromDate;

    /**
     * 管家服务开始结束
     */
    private LocalDateTime butlerEndDate;

    /**
     * 微信Open ID
     */
    private String weChatOpenId;

    /**
     * 子渠道
     */
    private String subChannel;

    /**
     * 待可用积分
     */
    private Integer ptPending;

    /**
     * 可用积分
     */
    private Integer ptUsable;

    /**
     * 即将失效积分
     */
    private Integer ptToBeExpired;

    /**
     * 失效积分
     */
    private Integer ptExpired;

    /**
     * 已使用积分
     */
    private Integer ptUsed;

    /**
     * 总共获得积分
     */
    private Integer ptAccPnt;

    /**
     * 创建人
     */
    private String crUsr;

    /**
     * 创建日期
     */
    private LocalDate crDat;

    /**
     * 创建时间
     */
    private Time crTim;

    /**
     * 修改人
     */
    private String chUsr;

    /**
     * 修改日期
     */
    private LocalDate chDat;

    /**
     * 修改时间
     */
    private Time chTim;

    /**
     * 删除标记
     */
    private String delFlg;
}
