package com.rocogz.syy.infrastructure.entity.dockingPlatform;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *  对接平台
 * </p>
 *
 * @author yinshihao
 * @since 2020-04-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "basic_docking_platform")
@JsonIgnoreProperties(ignoreUnknown = true)
public class DockingPlatform extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 平台编码
     */
    private String code;

    /**
     * 平台名称
     */
    private String name;

    /**
     * 平台秘钥
     */
    private String platformSecretKey;

    /**
     * 平台iv
     */
    private String platformIv;

    /**
     * 回跳地址
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String reboundAddr;

    /**
     * 是否发放优惠券(分为 Y/N )
     */
    private String provideCoupon;

    /**
     * 状态(分为 OPEN/LOCK )
     */
    private String status;

    /**
     * 公钥
     */
    private String publicKey;

    /**
     * 私钥
     */
    private String privateKey;

}
