package com.rocogz.syy.infrastructure.dto.samsung.req;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * <dl>
 * <dd>Description: 短信验证 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-11-04 10:38:55</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class SmsVerifyParamDto extends CommonReqDto {

    /**
     * 短信类型
     * A - MCS等门店渠道注册会员时验证手机号码短信.
     * S - 会员绑定手机号码
     * H - 会员修改手机号码
     * Z - 会员注册手机号码验证码
     * U - 使用积分手机号码验证码
     * P - 积分使用取消
     * B - 参加活动
     * C - 积分到期通知
     * D - 三星帐户密码通知
     */
    @NotNull
    private String smsType;

    /**
     * 短信验证码
     */
    @NotNull
    private String otpNo;

}
