package com.rocogz.syy.infrastructure.dto.samsung.req;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description:  service</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
public class PointUseAndCancelParamDto {

    /**
     * 接口ID
     */
    private String intfId;

    /**
     * 会员id
     */
    @NotNull
    private String memberId;

    /**
     * 交易类型：R-使用，C-取消
     */
    @NotNull
    private String txnType;

    /**
     * 批准号码：(CANCEL是传入)
     * 退货时以APPR_NO为第一优先，REF_ID第二优先
     */
    private String apprNo;

    /**
     * 系统订单编号: txnType为CANCEL时此参数必传
     */
    @NotNull
    private String refId;

    /**
     * 商品名称
     */
    @NotNull
    private String prdName;

    /**
     * 交易日期
     */
    @NotNull
    private String txnDt;

    /**
     * 交易时间
     */
    @NotNull
    private String txnTime;

    /**
     * 积分类型：默认SPNT
     */
    @NotNull
    private String pointType;

    /**
     * 积分金额
     */
    @NotNull
    private BigDecimal pointAmount;

    /**
     * 渠道
     */
    private String chlcd;

    /**
     * 门店ID(MPOS必输）
     */
    private String chnlId;

    /**
     * 手机号
     */
    @NotNull
    private String mobile;

    /**
     * 短信验证码
     * 当txnType：参数为U时此参数不可为空
     */
    private String otpNo;
}
