package com.rocogz.syy.infrastructure.dto.samsung.req;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * <dl>
 * <dd>Description: 同步订单数据 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-11-12 09:22:55</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class SyncOrderParamDto {

    /**
     * 会员coupon返回三星传送的值
     */
    @NotNull
    private String coupon;

    /**
     * 订单类型:DI-碎屏险，EW-延保，QY-爱奇艺， GIFT-礼品兑换，ALL-多类型合并支付
     */
    @NotNull
    private String type;

    /**
     * 会员ID
     */
    @NotNull
    private String memID;

    /**
     * 支付单号
     */
    @NotNull
    private String tranID;


    /**
     * 爱奇艺会员卡号
     */
    private String videoCoupon;

    /**
     * 支付现金(无现金支付为0)
     */
    @NotNull
    private String payCash;

    /**
     * 支付积分(无积分支付为0)
     */
    @NotNull
    private String payPoint;

    /**
     * 是否分期: Y-分期，N-不分期
     */
    @NotNull
    private String payStageYN;

    /**
     * 分期期数，如分期此参数必填
     */
    private String payStageNum;



}
