package com.rocogz.syy.infrastructure.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.infrastructure.dto.log.ApiRequestLogStatisticsResponseDto;
import com.rocogz.syy.infrastructure.dto.login.PlatformUserCipherDto;
import com.rocogz.syy.infrastructure.dto.sms.SmsParamDto;
import com.rocogz.syy.infrastructure.dto.system.SetPermissionDto;
import com.rocogz.syy.infrastructure.dto.tree.CustomMenuTreeDto;
import com.rocogz.syy.infrastructure.dto.tree.MenuTreeDto;
import com.rocogz.syy.infrastructure.dto.weixin.WeixinSubscribeMessageDto;
import com.rocogz.syy.infrastructure.entity.adminuser.AdminUser;
import com.rocogz.syy.infrastructure.entity.apiInfomation.ApiInformation;
import com.rocogz.syy.infrastructure.entity.area.entity.ProvCityArea;
import com.rocogz.syy.infrastructure.entity.dict.DictData;
import com.rocogz.syy.infrastructure.entity.dict.DictLicensePrefix;
import com.rocogz.syy.infrastructure.entity.dict.DictType;
import com.rocogz.syy.infrastructure.entity.dockingPlatform.DockingPlatform;
import com.rocogz.syy.infrastructure.entity.dockingPlatform.DockingPlatformIpAddr;
import com.rocogz.syy.infrastructure.entity.log.MallApiRequestLog;
import com.rocogz.syy.infrastructure.entity.menu.CustomMenu;
import com.rocogz.syy.infrastructure.entity.menu.Menu;
import com.rocogz.syy.infrastructure.entity.permission.UserDataPermission;
import com.rocogz.syy.infrastructure.entity.platformcipher.PlatformUserCipher;
import com.rocogz.syy.infrastructure.entity.role.Role;
import com.rocogz.syy.infrastructure.entity.subscription.entity.BasicWxSubscription;
import com.rocogz.syy.infrastructure.entity.wechat.WechatOpenAdminUser;
import com.rocogz.syy.infrastructure.entity.wechat.WechatOpenLoginLog;
import com.rocogz.syy.infrastructure.entity.wechat.WechatOpenUserinfo;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>Description: IInfrastructureClientService</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/10 10:48</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@SuppressWarnings("all")
public interface IInfrastructureClientService {

    /*********************************************   ranxiangfu 发送短信相关 Start   ********************************************************************/
    /**
     * 发送短信.
     *
     * @param smsParamDto the sms param dto
     * @return the response
     */
    @PostMapping("/api/basic/sms/send")
    Response<String> sendShortMsg(@RequestBody SmsParamDto smsParamDto);

    /*********************************************   ranxiangfu 发送短信相关 end   ********************************************************************/

    /*********************************************  ranxiangfu 省份-城市-区域相关 Start   ****************************************************************/

    /**
     * 根据父级编码获取所有下级区域.
     *
     * @param pcode 父级编码
     * @return the children by pcode
     */
    @GetMapping("/api/basic/prov-city-area/getChildrenByPcode")
    Response<List<ProvCityArea>> getProvCityAreaListByPcode(@RequestParam("pcode") String pcode);

    /**
     * 根据父级编码获取所有下级区域. ( like PCode%)
     *
     * @param pcode 父级编码
     * @return the children by pcode
     */
    @GetMapping("/api/basic/prov-city-area/getChildrenByPcodeWithLike")
    Response<List<ProvCityArea>> getChildrenByPcodeWithLike(@RequestParam("pcode") String pcode);
    /*********************************************   ranxiangfu 省份-城市-区域相关 end   ********************************************************************/

    /*********************************************  yinshihao 字典值相关 Start   ****************************************************************/
    /**
     * 字典值列表 不需要分页
     *
     * @param pCode    父常量ID
     * @param typeCode 类型编码
     * @param status   the status
     * @param code     the code
     * @param keyword  the keyword
     * @return response response
     */
    @GetMapping("/api/dict/data")
    Response<List<DictData>> searchDictData(@RequestParam(value = "pCode", required = false) String pCode,
                                            @RequestParam(value = "typeCode", required = false) String typeCode,
                                            @RequestParam(value = "status", required = false) String status,
                                            @RequestParam(value = "code", required = false) String code,
                                            @RequestParam(value = "keyword", required = false) String keyword);

    /**
     * 根据id查询字典值信息
     *
     * @param id id
     * @return dict data
     */
    @GetMapping("/api/dict/data/{id}")
    Response<DictData> getDictData(@PathVariable("id") Long id);

    /**
     * 字典类型状态改变
     *
     * @param id     用户id
     * @param status 改变后的状态
     * @return response response
     */
    @PostMapping("/api/dict/data/status/{id}")
    Response switchDictDataStatus(@PathVariable("id") Long id, @RequestParam("status") String status);

    /**
     * Batch edit dict data response.
     *
     * @param dictDatas the dict datas
     * @return the response
     */
    @PostMapping("/api/dict/data/batchEdit")
    Response batchEditDictData(@RequestBody List<DictData> dictDatas);

    /**
     * 根据类型编码获取字典数据
     *
     * @param typeCode the type code
     * @return dict data by type code
     */
    @GetMapping("/api/dict/data/get/{typeCode}")
    Response<List<DictData>> getDictDataByTypeCode(@PathVariable("typeCode") String typeCode);

    /**
     * 根据类型编码和状态获取字典数据
     *
     * @return
     */
    @GetMapping("/api/dict/data/getDictDataByTypeCodeAndStatus/{typeCode}")
    Response<List<DictData>> getDictDataByTypeCodeAndStatus(@PathVariable("typeCode") String typeCode,@RequestParam("status") String status);

    /**
     * 根据多种类型编码获取对应的字典数据
     *
     * @param typeCodeList 字典类型集合
     * @return dict data by type code list
     */
    @GetMapping("/api/dict/data/getDataByTypeCodeList")
    Response<Map<String, List<DictData>>> getDictDataByTypeCodeList(@RequestParam("typeCodeList") List<String> typeCodeList);

    /**
     * 根据类型编码和数据编码获取字典数据
     *
     * @param typeCode 类型编码
     * @param code     数据编码
     * @return
     */
    @GetMapping("/api/dict/data/getDictDataByTypeCodeAndCode")
    Response<DictData> getDictDataByTypeCodeAndCode(@RequestParam("typeCode") String typeCode,
                                                    @RequestParam("code") String code);
    /*********************************************   yinshihao 字典值相关 end   ********************************************************************/

    /*********************************************  yinshihao 字典类型相关 Start   ****************************************************************/

    /**
     * 字典类型列表
     *
     * @param keyword 查询关键字
     * @param limit   每页条数
     * @param page    页码
     * @return page table
     */
    @GetMapping("/api/dict/type")
    PageTable<DictType> searchDictType(@RequestParam(value = "keyword", required = false) String keyword,
                                       @RequestParam(value = "limit", defaultValue = "20") int limit,
                                       @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据id查询字典值信息
     *
     * @param id id
     * @return dict type
     */
    @GetMapping("/api/dict/type/{id}")
    Response<DictType> getDictType(@PathVariable("id") Long id);

    /**
     * 字典类型状态改变
     *
     * @param id     用户id
     * @param status 改变后的状态
     * @return response response
     */
    @PostMapping("/api/dict/type/status/{id}")
    Response switchDictTypeStatus(@PathVariable("id") Long id, @RequestParam("status") String status);

    /**
     * 添加或编辑字典类型
     *
     * @param type 字典类型
     * @return response response
     */
    @PostMapping("/api/dict/type")
    Response saveOrUpdateDictType(DictType type);

    /**
     * 根据类型编码列表和状态获取字典类型及数据
     *
     * @return
     */
    @GetMapping("/api/dict/type/getDictTypeByTypeCodes")
    Response<List<DictType>> getDictDataByTypeCodeAndStatus(@RequestParam("typeCodes") List<String> typeCodes, @RequestParam(value = "dataStatus",required = false) String dataStatus);
    /*********************************************   yinshihao 字典类型相关 end   ********************************************************************/

    /*********************************************  yinshihao 对接平台相关 Start   ****************************************************************/

    /**
     * 对接平台列表
     *
     * @param keyword 对接平台名称或编码
     * @param status  标签状态
     * @param limit   每页条数
     * @param page    页码
     * @return page table
     */
    @GetMapping("/api/basic/dockingPlatform")
    PageTable<DockingPlatform> findDockingPlatformList(@RequestParam(value = "keyword", required = false) String keyword,
                                                       @RequestParam(value = "status", required = false) String status,
                                                       @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                       @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 对接平台状态改变
     *
     * @param dockingPlatform the docking platform
     * @return response response
     */
    @PostMapping("/api/basic/dockingPlatform/changeDockingPlatformstatus")
    Response changeDockingPlatformstatus(@RequestBody DockingPlatform dockingPlatform);

    /**
     * 根据id查询对接平台信息
     *
     * @param id 对接平台id
     * @return docking platform by id
     */
    @GetMapping("/api/basic/dockingPlatform/{id}")
    Response<DockingPlatform> getDockingPlatformById(@PathVariable("id") Integer id);

    /**
     * 根据code查询对接平台信息
     *
     * @param code   对接平台code
     * @param status 对接平台状态
     * @return
     */
    @GetMapping("/api/basic/dockingPlatform/getDockingPlatformByCode")
    Response<DockingPlatform> getDockingPlatformByCode(@RequestParam("code") String code, @RequestParam(value = "status", required = false) String status);

    /**
     * 创建或更新对接平台
     *
     * @param dockingPlatform the docking platform
     * @return response response
     */
    @PostMapping("/api/basic/dockingPlatform/saveOrUpdateDockingPlatform")
    Response saveOrUpdateDockingPlatform(@RequestBody DockingPlatform dockingPlatform);

    /**
     * 获取对接平台列表(不返回key和iv)
     *
     * @param provideCoupon 是否发放优惠券
     * @param status        状态
     * @return
     */
    @GetMapping("/api/basic/dockingPlatform/findDockingPlatformListNoKeyAndIv")
    Response<List<DockingPlatform>> findDockingPlatformListNoKeyAndIv(@RequestParam(value = "provideCoupon", required = false) String provideCoupon,
                                                                      @RequestParam(value = "status", required = false) String status);

    /**
     * 根据平台编码获取对接平台信息(不返回key和iv)
     *
     * @param code 平台编码
     * @return
     */
    @GetMapping("/api/basic/dockingPlatform/getDockingPlatformByCodeNoKeyAndIv")
    Response<DockingPlatform> getDockingPlatformByCodeNoKeyAndIv(@RequestParam("code") String code);

    /**
     * 根据平台编码集合获取对应的对接平台信息(不返回key和iv)
     *
     * @param codeList 平台编码集合
     * @return
     */
    @GetMapping("/api/basic/dockingPlatform/getDockingPlatformListByCodeListNoKeyAndIv")
    Response<List<DockingPlatform>> getDockingPlatformListByCodeListNoKeyAndIv(@RequestParam("codeList") List<String> codeList);

    /*********************************************   yinshihao 对接平台相关 end   ********************************************************************/

    /*********************************************  yinshihao 接口权限相关 Start   ****************************************************************/

    /**
     * 查询接口权限列表
     *
     * @param platformCode 平台编码
     * @param serviceName  服务名
     * @param name         接口名
     * @param limit        the limit
     * @param page         the page
     * @return page table
     */
    @GetMapping("/api/basic/apiInfomation/queryApi")
    PageTable<ApiInformation> queryApi(@RequestParam(value = "platformCode", required = false) String platformCode,
                                       @RequestParam(value = "serviceName", required = false) String serviceName,
                                       @RequestParam(value = "name", required = false) String name,
                                       @RequestParam(value = "limit", defaultValue = "20") int limit,
                                       @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 查询接口权限列表
     *
     * @param serviceName 服务名
     * @param name        接口名
     * @return
     */
    @GetMapping("/api/basic/apiInfomation/findApiInformationList")
    PageTable<ApiInformation> findApiInformationList(@RequestParam(value = "serviceName", required = false) String serviceName,
                                                     @RequestParam(value = "name", required = false) String name,
                                                     @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                     @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 无查询条件下查询接口权限列表
     *
     * @param limit the limit
     * @param page  the page
     * @return page table
     */
    @GetMapping("/api/basic/apiInfomation/queryApiList")
    PageTable<ApiInformation> queryApiList(@RequestParam(value = "limit", defaultValue = "20") int limit,
                                           @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据平台编码删除对应接口信息
     *
     * @param platformCode the platform code
     * @param apiId        the api id
     * @return response response
     */
    @GetMapping("/api/basic/apiInfomation/deleteApiByPlatformCode")
    Response deleteApiByPlatformCode(@RequestParam(value = "platformCode") String platformCode,
                                     @RequestParam(value = "apiId") Integer apiId);

    /**
     * 根据平台编码获取其对应的接口列表
     *
     * @param platformCode the platform code
     * @return api list by platform code
     */
    @GetMapping("/api/basic/apiInfomation/getApiListByPlatformCode")
    Response<List<ApiInformation>> getApiListByPlatformCode(@RequestParam(value = "platformCode") String platformCode);

    /**
     * 根据平台编码获取其对应的接口列表
     *
     * @param platformCode the platform code
     * @param status       the status
     * @return api list by platform code
     */
    @GetMapping("/api/basic/apiInfomation/getApiListByPlatformCodeAndStatus")
    Response<List<ApiInformation>> getApiListByPlatformCodeAndStatus(@RequestParam(value = "platformCode") String platformCode, @RequestParam(value = "status") String status);

    /**
     * 修改平台的接口状态
     *
     * @param apiId        接口id
     * @param status       该平台下该接口的状态
     * @param platformCode 平台编码
     * @param updateUser   操作用户
     * @return response response
     */
    @PostMapping("/api/basic/apiInfomation/changePlatformApiStatusById/{apiId}")
    Response changePlatformApiStatusById(@PathVariable("apiId") Integer apiId,
                                         @RequestParam("status") String status,
                                         @RequestParam("platformCode") String platformCode,
                                         @RequestParam("updateUser") String updateUser);

    /**
     * 根据平台编码添加其对应的接口
     *
     * @param apiIdList    添加的接口列表
     * @param platformCode 平台编码
     * @param updateUser   操作用户
     * @return response response
     */
    @PostMapping("/api/basic/apiInfomation/addApiListByPlatformCode")
    Response addApiListByPlatformCode(@RequestParam("apiIdList") List<Integer> apiIdList,
                                      @RequestParam("platformCode") String platformCode,
                                      @RequestParam("updateUser") String updateUser);

    /*********************************************   yinshihao 接口权限相关 end   ********************************************************************/

    /*********************************************  zhangmin 车牌号 前缀相关 Start   ****************************************************************/

    /**
     * 根据 省名称 / 城市名 通配符 获得车牌号前缀
     *
     * @param provName 省名称
     * @param cityName 城市名称
     * @return
     */
    @RequestMapping("/api/basic/dict/dictLicensePrefix")
    Response<DictLicensePrefix> getLicensePrefixByProvCityNameLike(@RequestParam("provName") String provName,
                                                                   @RequestParam("cityName") String cityName);

    /*********************************************   zhangmin 车牌号 前缀相关 end   ********************************************************************/

    /*********************************************  yinshihao 用户相关 Start   ****************************************************************/

    /**
     * 管理员用户列表
     *
     * @param username 账户名
     * @param name     姓名
     * @param roleId   角色id
     * @param status   账号状态
     * @param type     账号类型
     * @param page     页码
     * @param limit    每页条数
     * @return
     */
    @GetMapping("/api/system/users")
    PageTable<AdminUser> findAdminUserList(@RequestParam(value = "username", required = false) String username,
                                           @RequestParam(value = "name", required = false) String name,
                                           @RequestParam(value = "roleId", required = false) String roleId,
                                           @RequestParam(value = "status", required = false) String status,
                                           @RequestParam(value = "type", required = false) String type,
                                           @RequestParam(value = "limit", defaultValue = "20") int limit,
                                           @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 查询用户所有菜单
     *
     * @return
     */
    @PostMapping("/api/system/users/findMenu")
    List<Menu> findMenuByAdminUserId(@RequestParam("userId") Integer userId);

    /**
     * 查询用户所有菜单
     *
     * @return
     */
    @PostMapping("/api/system/users/findCustomMenu")
    List<Menu> findCustomMenuByAdminUserIdAndType(@RequestParam("userId") Integer userId, @RequestParam("type") String type);

    /**
     * 新建管理员用户
     *
     * @param user 管理员用户信息
     * @return
     */
    @PostMapping("/api/system/users")
    Response createAdminUser(AdminUser user);

    /**
     * 更新管理员用户
     *
     * @param user 管理员用户信息
     * @return
     */
    @PostMapping("/api/system/users/edit")
    Response editAdminUser(AdminUser user);

    /**
     * 根据id查询用户信息
     *
     * @param id 用户id
     * @return
     */
    @GetMapping("/api/system/users/{id}")
    Response<AdminUser> getAdminUserById(@PathVariable("id") Long id);

    /**
     * 重置用户密码
     *
     * @param id 用户id
     * @return
     */
    @GetMapping("/api/system/users/{id}/password")
    Response resetAdminUserPwd(@PathVariable("id") Long id);

    /**
     * 根据用户id查询用户角色信息
     *
     * @param id 用户id
     * @return
     */
    @GetMapping("/api/system/users/role/{id}")
    Response<List<Role>> getAdminUserRolesById(@PathVariable("id") Long id);

    /**
     * 为用户设置角色信息
     *
     * @param id      用户id
     * @param roleIds 角色ids
     * @return
     */
    @PostMapping("/api/system/users/role/{id}")
    Response setAdminUserRolesById(@PathVariable("id") Long id, @RequestParam("roleIds") long[] roleIds);

    /**
     * 用户状态改变
     *
     * @param id     用户id
     * @param status 改变后的状态
     * @return
     */
    @PostMapping("/api/system/users/status/{id}")
    Response switchAdminUserStatus(@PathVariable("id") Long id, @RequestParam("status") String status);

    /**
     * 根据id删除用户（逻辑删除）
     *
     * @param id 用户id
     * @return
     */
    @GetMapping("/api/system/users/delete/{id}")
    Response deleteAdminUserById(@PathVariable("id") Long id);

    /**
     * 修改用户密码
     *
     * @param oldPwd     原密码
     * @param newPwd     新密码
     * @param confirmPwd 确认密码
     * @param userId     用户Id
     * @return
     */
    @PostMapping(value = "/api/system/users/password/modify")
    Response updateAdminUserPwd(@RequestParam("oldPwd") String oldPwd, @RequestParam("newPwd") String newPwd, @RequestParam("confirmPwd") String confirmPwd, @RequestParam("userId") Integer userId);

    /**
     * 批量启用用户
     *
     * @param idList
     * @return
     */
    @RequestMapping("/api/system/users/batch/open")
    Response batchOpenAdminUser(@RequestBody List<Long> idList);

    /**
     * 批量停用用户
     *
     * @param idList
     * @return
     */
    @RequestMapping("/api/system/users/batch/lock")
    Response batchLockAdminUser(@RequestBody List<Long> idList);

    /**
     * 批量重置密码
     *
     * @param idList
     * @return
     */
    @RequestMapping("/api/system/users/batch/resetpwd")
    Response resetAdminUserPwd(@RequestBody List<Long> idList);

    /**
     * @param id
     * @return
     */
    @PostMapping("/api/system/users/getAllInfoById")
    AdminUser getAdminUserAllInfoById(@RequestParam("id") Integer id);

    /**
     * 根据用户名查询用户的所有信息（角色、权限）
     *
     * @param username 用户名
     * @return
     */
    @PostMapping("/api/system/users/getAllInfoByUsername")
    AdminUser getAdminUserAllInfoByUsername(@RequestParam("username") String username,
                                            @RequestParam(value = "type") String type);

    /**
     * 激活用户
     *
     * @param id       用户id
     * @param password 用户密码
     * @return
     */
    @PostMapping("/api/system/users/active")
    Response activeAdminUser(@RequestParam("id") Long id, @RequestParam("password") String password);

    /**
     * 根据用户名列表查询 用户名称列表
     *
     * @param usernames
     * @return
     */
    @PostMapping("/api/system/users/names")
    Response<List<AdminUser>> queryAccountListByUsenames(@RequestBody List<String> usernames);

    /**
     * 根据角色id查询对应的用户列表
     *
     * @param roleId 角色id
     * @return
     */
    @GetMapping("/api/system/users/getUserListByRoleId/{roleId}")
    Response<List<AdminUser>> getUserListByRoleId(@PathVariable("roleId") Integer roleId);

    /**
     * 根据手机号码查询对应的用户列表
     *
     * @param mobile
     * @return
     */
    @GetMapping("/api/system/users/getByMobile")
    Response<List<AdminUser>> getUserByMobile(@RequestParam("mobile") String mobile);

    /*********************************************   yinshihao 用户相关 end   ********************************************************************/

    /*********************************************  yinshihao 用户角色相关 Start   ****************************************************************/

    /**
     * 角色列表
     *
     * @param keyword 查询关键字
     * @param type 角色类型
     * @param page    页码
     * @param limit   每页条数
     * @return
     */
    @GetMapping("/api/system/role")
    PageTable<Role> pageFindRoleList(@RequestParam(value = "keyword", required = false) String keyword,
                                     @RequestParam(value = "type", required = false) String type,
                                     @RequestParam(value = "limit", defaultValue = "20") int limit,
                                     @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 添加或编辑角色信息
     *
     * @param role 角色信息
     * @return
     */
    @PostMapping("/api/system/role")
    Response saveOrUpdateRole(Role role);

    /**
     * 根据id查询角色信息
     *
     * @param id 角色id
     * @return
     */
    @GetMapping(value = "/api/system/role/{id}")
    Response<Role> getRoleById(@PathVariable("id") Long id);

    /**
     * 删除角色
     *
     * @Param id
     */
    @GetMapping(value = "/api/system/role/delete/{id}")
    Response deleteRole(@PathVariable("id") Long id);

    /**
     * 查询角色绑定的权限及未绑定权限
     *
     * @param id 角色id
     * @param type 类型-自定义菜单时传(BIZ/PLATFORM)
     * @return
     */
    @GetMapping(value = "/api/system/role/permission/{id}")
    Response<List<SetPermissionDto>> findRolePermission(@PathVariable("id") Long id, @RequestParam(value = "type", required = false) String type);

    /**
     * 设置角色权限
     *
     * @param id             主键
     * @param permissionDtos 菜单权限和操作权限DTO
     * @return
     */
    @PostMapping(value = "/api/system/role/permission/{id}")
    Response setRolePermissions(@PathVariable("id") Long id, List<SetPermissionDto> permissionDtos);

    /**
     * 根据用户id查询用户角色信息
     *
     * @param id 用户id
     * @return
     */
    @GetMapping("/api/system/role/role/{id}")
    Response<List<Role>> getRolesByUserId(@PathVariable("id") Long id);

    /**
     * 为用户设置角色信息
     *
     * @param id      用户id
     * @param roleIds 角色ids
     * @return
     */
    @PostMapping("/api/system/role/role/{id}")
    Response setRolesByUserId(@PathVariable("id") Long id, @RequestParam("roles") long[] roleIds);

    /**
     * 获取所有角色信息
     *
     * @param roleType  角色类型
     * @return
     */
    @GetMapping("/api/system/role/findRoleList")
    Response<List<Role>> findRoleList(@RequestParam(value = "roleType",required = false)String roleType);

    /*********************************************  yinshihao 用户角色相关 end   ****************************************************************/

    /*********************************************  yinshihao 菜单相关 Start   ****************************************************************/

    /**
     * 菜单列表
     *
     * @param pid   父菜单ID
     * @param page  页码
     * @param limit 每页条数
     * @return
     */
    @GetMapping("/api/menu")
    PageTable<Menu> findMenuList(@RequestParam("pid") Long pid,
                                 @RequestParam(value = "limit", defaultValue = "20") int limit,
                                 @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 左侧菜单列表
     *
     * @return
     */
    @GetMapping("/api/menu/findMenuTree")
    Response<List<MenuTreeDto>> findMenuTree();

    /**
     * 菜单详情
     *
     * @param id
     * @return
     */
    @GetMapping("/api/menu/getById/{id}")
    Response<Menu> getMenuById(@PathVariable("id") Long id);

    /**
     * 编辑菜单
     *
     * @param menu
     * @return
     */
    @PostMapping("/api/menu")
    Response editMenu(Menu menu);

    /**
     * 获取所有的启用菜单
     *
     * @return
     */
    @GetMapping("/api/menu/findAllOpen")
    Response<List<Menu>> findAllOpenMenu();

    /**
     * 根据菜单id状态改变
     *
     * @param id     菜单id
     * @param status 改变后的状态
     * @return
     */
    @PostMapping("/api/menu/status/{id}")
    Response switchStatus(@PathVariable("id") Integer id, @RequestParam("status") String status);

    /*********************************************   yinshihao 菜单相关 end   ********************************************************************/

    /*********************************************  hsf 自定义菜单相关 Start   ****************************************************************/
    /**
     * 自定义菜单列表
     *
     * @return
     */
    @GetMapping("/api/custom/menu/findMenuTree")
    Response<List<CustomMenuTreeDto>> findCustomMenuTree(@RequestParam("type") String type);

    /**
     * 自定义菜单列表ztree形式
     *
     * @param type
     * @param flag
     * @return
     */
    @GetMapping("/api/custom/menu/findMenuZTree")
    Response<List<Menu>> findCustomMenuZTree(@RequestParam("type") String type, @RequestParam("flag") String flag);

    /**
     * 自定义菜单更新
     *
     * @param menu
     * @return
     */
    @PostMapping("/api/custom/menu/update")
    Response updateCustomMenu(@RequestBody CustomMenu menu);

    /**
     * 自定义菜单详情
     *
     * @param id
     * @return
     */
    @GetMapping("/api/custom/menu/detail/{id}")
    Response<CustomMenu> customMenuDetail(@PathVariable("id") Integer id);

    /**
     * 自定义菜单分页
     *
     * @param pid
     * @param type
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/custom/menu")
    PageTable<CustomMenu> customMenuSearchScrollPage(@RequestParam(value = "pid", required = false) Integer pid,
                                           @RequestParam("type") String type,
                                           @RequestParam("limit") int limit,
                                           @RequestParam("page") int page);

    /**
     * 自定义菜单更新状态
     * @param customMenu
     * @return
     */
    @PostMapping("/api/custom/menu/updateStatus")
    Response customMenuUpdateStatus(@RequestBody CustomMenu customMenu);

    /**
     * 自定义菜单删除
     * @param id
     * @return
     */
    @GetMapping("/api/custom/menu/delete/{id}")
    Response customMenuDelete(@PathVariable("id") Integer id);

    /*********************************************  hsf 自定义菜单相关 End   ****************************************************************/

    /*********************************************   liangyongtong 小程序订阅消息 start   ********************************************************************/
    /**
     * 发送订阅消息
     *
     * @param message 消息对象
     * @return
     */
    @PostMapping("/api/weixin/message/send")
    Response sendSubcribeMsg(@RequestBody WeixinSubscribeMessageDto message);

    /**
     * 通过模板id 和 openid 获取对象
     * @param templateId
     * @param openid
     * @return
     */
    @GetMapping("/api/weixin/message/subscription/queryInfo")
    Response<BasicWxSubscription> getInfoByTemplateIdAndOpenId(@RequestParam(value = "templateId") String templateId, @RequestParam(value = "openid") String openid, @RequestParam(value = "businessCode", required = false) String businessCode);

    /**
     * 保存对象
     * @param subscription
     */
    @PostMapping("/api/weixin/message/subscription/saveInfo")
    Response saveSubscriptionInfo(@RequestBody BasicWxSubscription subscription);

    /**
     * 删除对象通过 模板id  和 openid
     * @param templateId
     * @param openid
     */
    @GetMapping("/api/weixin/message/subscription/delete")
    Response deleteByTemplateIdAndOpenId(@RequestParam(value = "templateId") String templateId, @RequestParam(value = "openid") String openid, @RequestParam(value = "businessCode", required = false) String businessCode);

    /*********************************************   liangyongtong 小程序订阅消息 end   ********************************************************************/

    /*********************************************   yinshihao 对接平台白名单 start   ********************************************************************/
    /**
     * 获取对接平台的白名单列表
     *
     * @param platformCode 对接平台编码
     * @return
     */
    @GetMapping("/api/basic/dockingPlatformIpAddr/findDockingPlatformIpAddrList")
    Response<List<DockingPlatformIpAddr>> findDockingPlatformIpAddrList(@RequestParam(value = "platformCode") String platformCode);

    /**
     * 更新对接平台的白名单列表
     *
     * @param platformCode              对接平台编码
     * @param dockingPlatformIpAddrList 对接平台白名单列表
     * @return
     */
    @PostMapping("/api/basic/dockingPlatformIpAddr/updateDockingPlatformIpAddrList")
    Response updateDockingPlatformIpAddrList(@RequestParam(value = "platformCode") String platformCode, @RequestBody List<DockingPlatformIpAddr> dockingPlatformIpAddrList);

    /*********************************************   lyinshihao 对接平台白名单 end   ********************************************************************/


    /*********************************************   ranxiangfu 特惠商城端接口请求日志 start   ********************************************************************/

    /**
     * 保存接口请求日志.
     */
    @PostMapping("/api/basic/mall-api-request-log/save")
    Response saveMallApiRequestLog(@RequestBody MallApiRequestLog apiRequestLog);

    /**
     * 分页查询
     * @param skyWalkingTid     skyWalkingTid
     * @param requestUrl        请求url
     * @param usedTimeMin       响应最小时间
     * @param usedTimeMax       响应最大时间
     * @param currentAccountCode 门店账号
     * @param currentUserOpenid  门店账号openId
     * @param currentUserMobile  门店账号手机号
     * @param className         请求接口类名
     * @param methodName        请求接口方法名
     * @param startTime         请求开始时间，已请求开始时间做判断
     * @param endTime           请求结束时间，已请求开始时间做判断
     * @param page              page
     * @param limit             limit
     * @return page
     */
    @GetMapping("/api/basic/mall-api-request-log")
    PageTable<MallApiRequestLog> findMallApiRequestLogs(
            @RequestParam(value = "skyWalkingTid", required = false) String skyWalkingTid,
            @RequestParam(value = "requestUrl", required = false) String requestUrl,
            @RequestParam(value = "usedTimeMin", required = false) Integer usedTimeMin,
            @RequestParam(value = "usedTimeMax", required = false) Integer usedTimeMax,
            @RequestParam(value = "currentAccountCode", required = false) String currentAccountCode,
            @RequestParam(value = "currentUserOpenid", required = false) String currentUserOpenid,
            @RequestParam(value = "currentUserMobile", required = false) String currentUserMobile,
            @RequestParam(value = "className", required = false) String className,
            @RequestParam(value = "methodName", required = false) String methodName,
            @RequestParam(value = "startTime", required = false) LocalDateTime startTime,
            @RequestParam(value = "endTime", required = false) LocalDateTime endTime,
            @RequestParam(value = "page", defaultValue = "1") Integer page,
            @RequestParam(value = "limit", defaultValue = "20") Integer limit);


    /**
     * 主要是配合在折线图筛选 查询的接口，需要去重操作，只返回，className,classMethod,requestUrl
     */
    @GetMapping("/api/basic/mall-api-request-log/distinctHandleMethod")
    PageTable<MallApiRequestLog> distinctMallApiLogHandleMethod(
            @RequestParam(value = "className", required = false) String className,
            @RequestParam(value = "methodName", required = false) String methodName,
            @RequestParam(value = "requestUrl", required = false) String requestUrl,
            @RequestParam(value = "startTime") LocalDateTime startTime,
            @RequestParam(value = "endTime") LocalDateTime endTime,
            @RequestParam(value = "page", defaultValue = "1") Integer page,
            @RequestParam(value = "limit", defaultValue = "20") Integer limit);




    /**
     * 只返回StartTime，UsedTimeMillis,配合折线图组装数据
     * @param className  类名
     * @param methodName 方法名
     * @param startTime  查询开始时间
     * @param endTime    查询结束时间
     */
    @GetMapping("/api/basic/mall-api-request-log/findApiLogList")
    Response<List<MallApiRequestLog>> findMallApiLogListByTimeRange(
            @RequestParam(value = "className", required = false) String className,
            @RequestParam(value = "methodName", required = false) String methodName,
            @RequestParam(value = "startTime") LocalDateTime startTime,
            @RequestParam(value = "endTime") LocalDateTime endTime);


    /**
     * 统计选定时间 topN 最大耗时和平均最大耗时数据
     * @param startTime 查询时间段 已开始时间为标准,必须填写
     * @param endTime   查询时间段 已开始时间为标准，必须填写
     */
    @GetMapping("/api/basic/mall-api-request-log/statisSpendTopN")
    Response<ApiRequestLogStatisticsResponseDto> statisMallApiLogMaxAvgSpendTopN(
            @RequestParam(value = "startTime") LocalDateTime startTime,
            @RequestParam(value = "endTime") LocalDateTime endTime,
            @RequestParam(value = "topN", defaultValue = "10") Integer topN);


    /*********************************************  ranxiangfu 特惠商城端接口请求日志  end ********************************************************************/



    /*********************************************  huhailong 数据权限管理相关 begin ********************************************************************/

    /**
     * 获取所有的数据权限
     * @param userId
     * @return
     */
    @RequestMapping("/api/system/datapermission/getUserDataPermissionByUserId")
    List<UserDataPermission> getUserDataPermissionByUserId(@RequestParam("userId") Integer userId);

    /**
     * 设置数据权限
     * @param userId 用户ID
     * @param permissions 权限
     * @return
     */
    @PostMapping(value = "/api/system/datapermission/permission/{userId}")
    Response setUserDataPermission(@PathVariable("userId") Integer  userId, @RequestBody List<UserDataPermission> permissions);


    /**
     * 菜单修改弹出层的菜单,返回菜单列表 修改父级菜单时可以选择任意菜单，除了自己和自己的子级
     *
     * @return
     */
    @GetMapping("/api/menu/findCanSelectedMenuTree")
    Response<List<MenuTreeDto>> findCanSelectedMenuTree(@RequestParam("currentId") Integer currentId);

    /*********************************************  huhailong 数据权限管理相关 end ********************************************************************/

    /*********************************************  lanqian 微信开发平台扫码登录，微信登录权限激活 begin*************************************************/
    /**
     * 新增激活码
     *
     * @param dto
     * @return Response
     */

    @PostMapping("/api/wxCipher/apply")
    Response applyWxCipher(@RequestBody PlatformUserCipherDto dto);

    /**
     * 分页查询激活码
     * @param page
     * @param limit
     * @param mobile
     * @param name
     * @param status
     * @return Response
     */
    @GetMapping(value = "/api/wxCipher/search")
     PageTable<PlatformUserCipher> searchWxCipherList(@RequestParam(value = "limit",defaultValue = "20") int limit,
                                                @RequestParam(value = "page",defaultValue = "1") int page,
                                                @RequestParam(value = "mobile", required = false) String mobile,
                                                @RequestParam(value = "name", required = false) String name,
                                                @RequestParam(value = "status", required = false) String status);
    /**
     * 删除激活码
     * @param id
     * @return Response
     */
    @GetMapping(value = "/api/wxCipher/delete/{id}")
    Response removeWxCipher(@PathVariable(value = "id") Long id);
    /**
     * 按手机号码和类型查询记录
     * @param mobile
     * @return Response
     */
    @GetMapping(value = "/api/wxCipher/getByMobile")
    Response<PlatformUserCipher> getWxCipherByMobile(@RequestParam(value = "mobile", required = false) String mobile);

    /**
     * 按微信openid和类型查询记录
     * @param openId
     * @return Response
     */
    @GetMapping(value = "/api/wxCipher/getByOpenId")
    Response<PlatformUserCipher> getWxCipherByOpenId(@RequestParam(value = "openId", required = false) String openId);
    /**
     * 按openid和类型检查是否被激活
     * @param openId
     * @return Response
     */
    @GetMapping(value = "/api/wxCipher/checkActivation")
    Response<Boolean> checkWxCipherActivation(@RequestParam(value = "openId", required = false) String openId);
    /**
     * 更新
     * @param entity
     * @return Response
     */
    @PostMapping(value = "/api/wxCipher/update")
    boolean updateWxCipher(@RequestBody PlatformUserCipher entity);

    /*********************************************  lanqian 微信开发平台扫码登录，微信登录权限激活 end*************************************************/

    /*********************************************  lanqian 微信开发平台扫码登录 begin*************************************************/
    /**
     * 获取平台用户和微信的绑定关系
     * @param openId
     * @return Response
     */
    @GetMapping(value = "/api/wechatOpenAdminUser/getByOpenId")
    Response<List<WechatOpenAdminUser>> getAdminUserByOpenId(@RequestParam(value = "openId", required = false)String openId,
                                                             @RequestParam(value = "type", required = false) String type);

    /**
     * 获取平台用户和微信的绑定关系
     * @param acctName
     * @return Response
     */
    @GetMapping(value = "/api/wechatOpenAdminUser/getByAcctName")
    Response<WechatOpenAdminUser> getAdminUserByAcctName(@RequestParam(value = "acctName", required = false)String acctName);

    /**
     * 删除平台用户和微信的绑定关系
     * @param openId
     * @return Response
     */
    @GetMapping(value = "/api/wechatOpenAdminUser/deleteByOpenId")
    Response<Boolean> deleteAdminUserByOpenId(@RequestParam(value = "openId", required = false)String openId);

    /**
     * 删除平台用户和微信的绑定关系
     * @param acctName
     * @return Response
     */
    @GetMapping(value = "/api/wechatOpenAdminUser/deleteByAcctName")
    Response<Boolean> deleteAdminUserByAcctName(@RequestParam(value = "acctName", required = false)String acctName);

    /**
     * 插入平台用户和平台用户的绑定关系
     */
    @PostMapping(value="/api/wechatOpenAdminUser/insert")
     Response<Boolean> insertAdminUser(@RequestBody WechatOpenAdminUser wechatOpenAdminUser);
    /**
     * 记录日志
     */
    @PostMapping("/api/wechatOpenLoginLog/insert")
    Response<Boolean> insertWechatOpenLoginLog(@RequestBody WechatOpenLoginLog wechatOpenLoginLog);

    /**
     * 更新或者插入记录
     * @param  wechatOpenUserinfo
     * @return
     * */
    @PostMapping("/api/wechatOpenUserInfo/saveOrUpdateUser")
    Response<Boolean>  saveOrUpdateUserinfo(@RequestBody WechatOpenUserinfo wechatOpenUserinfo);
    /**
     *根据openid获取记录
     * @param openId
     * @return
     *  */
    @GetMapping(value = "/api/wechatOpenUserInfo/getByOpenId")
    Response<WechatOpenUserinfo>  getUserInfoByOpenId(@RequestParam(value = "openId", required = false)String openId);

    /**
     *根据本地临时凭证token获取记录
     * @param token
     * @return
     *  */
    @GetMapping(value = "/api/wechatOpenUserInfo/getByToken")
    Response<WechatOpenUserinfo>  getUserInfoByToken(@RequestParam(value = "token", required = false)String token);

    /*********************************************  lanqian 微信开发平台扫码登录 end*************************************************/

    /**
     * 根据用户id和角色类型查询用户角色信息
     *
     * @param id 用户id
     * @param roleType 角色类型
     * @return
     */
    @GetMapping("/api/system/role/role/{id}/{roleType}")
    Response<List<Role>> getRolesByUserIdAndRoleType(@PathVariable("id") Long id,@PathVariable("roleType")String roleType);

    /**
     * 根据用户id和角色类型为用户设置角色信息
     *
     * @param id      用户id
     * @param roleIds 角色ids
     * @param roleType 角色类型
     * @return
     */
    @PostMapping("/api/system/users/role/{id}/{roleType}")
    Response setAdminUserRolesByIdAndRoleType(@PathVariable("id") Long id, @RequestParam("roleIds") long[] roleIds,@PathVariable("roleType")String roleType);

    /**
     * 根据用户id和角色类型为用户设置角色信息
     *
     * @param mobile
     * @return
     */
    @GetMapping("/api/system/users/register")
    Response register(@RequestParam("mobile") String mobile);

    /**
     * 根据用户id和角色类型为用户设置角色信息
     *
     * @param mobile
     * @return
     */
    @GetMapping("/api/system/users/unRegister")
    Response unRegister(@RequestParam("mobile") String mobile);
}
