package com.rocogz.syy.infrastructure.dto.samsung.req;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * <dl>
 * <dd>Description: 积分商城5折电池折扣券订单状态修改接口 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-11-10 16:12:26</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class BcouponReceiveParamDto {

    /**
     * 会员号：会员ID和SA GUID必须输入一项，同时输入以会员ID为准
     */
    @NotNull
    private String memberId;

    /**
     * SA GUID：会员ID和SA GUID必须输入一项，同时输入以会员ID为准
     */
    private String saGuid;

    /**
     * 传入：S-Spen，B-Battery, C-后壳
     */
    @NotNull
    private String type;

    /**
     * 产品型号
     */
    @NotNull
    private String prodModel;

    /**
     * IMEI
     */
    @NotNull
    private String imei;

    /**
     * 电池折扣券码
     */
    @NotNull
    private String bcouponNo;

    /**
     * 5折电池折扣券或Spen购买日期，格式：yyyyMMdd
     */
    @NotNull
    private String bcouponSaleDt;

    /**
     * 5折电池折扣券有效开始日期，格式：yyyyMMdd
     */
    @NotNull
    private String bcouponStartDt;

    /**
     * 5折电池折扣券有效结束日期，格式：yyyyMMdd
     */
    @NotNull
    private String bcouponEndDt;

    /**
     * 5折电池折扣券购买金额, 无金额传：0
     */
    @NotNull
    private String bcouponAmt;

    /**
     * 5折电池折扣券积分金额, 无积分传入0
     */
    @NotNull
    private String bcouponPntAmt;

    /**
     * 订单号
     */
    @NotNull
    private String bcouponSaleNo;

    /**
     * 购买状态:
     * A-购买
     * C-已取消
     * R-退货
     * U-已使用
     */
    @NotNull
    private String bcouponSaleSt;

}
