package com.rocogz.syy.infrastructure.dto.sms;

import com.rocogz.syy.infrastructure.enumerate.SmsTemplateTypeEnum;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * <dl>
 * <dd>Description: SmsParamDto</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/13 17:03</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
public class SmsParamDto {
    /**
     * 手机号码.
     */
    @NotBlank(message = "手机号不能为空")
    @Length(max = 11,min = 11, message = "手机号长度错误")
    String mobile;

    /**
     * 验证码.
     */
    @NotBlank(message = "验证码不能为空")
    String code;

    /**
     * 短信模板类型.
     */
    @NotNull(message = "短信模板类型不能为空")
    SmsTemplateTypeEnum templateType;
}
