package com.rocogz.syy.infrastructure.dto.samsung.req;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * <dl>
 * <dd>Description: 微信、支付宝绑定解绑dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-11-17 17:32:42</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class WechatAliBindUnBindParamDto{

    @NotNull
    private String memberId;

    /**
     * 渠道：WECHAT-微信，ALI-支付宝
     */
    @NotNull
    private String chlcd;

    /**
     * 子渠道：NPMALL-积分商城， NPMALL_MINI-积分商城小程序
     */
    private String subChannel;

    /**
     * unionId
     */
    @NotNull
    private String unionId;

    /**
     * openid
     */
    @NotNull
    private String openId;

    /**
     * 昵称
     */
    @NotNull
    private String openName;

    /**
     * 头像url
     */
    @NotNull
    private String openNameUrl;

    /**
     * sa guid
     */
    private String saGuid;

    /**
     * 绑定时该字段为空，解绑时该字段为Y
     */
    private String unBind;
}
