/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.infrastructure.dto.trace;

import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class TraceDto {
    public static final TraceDto EMPTY_TRACE_DTO = new TraceDto();
    public LocalDateTime callStartTime;
    private String respMsg;
    private String respCode;
    private String errorClassName;
    private Integer errorLine;
    private String errorMethod;
    private String stackTrace;
    private Long spendMillis;

    public void setStartTimeAndCalcSpend(LocalDateTime callStartTime) {
        this.callStartTime = callStartTime;
        if (callStartTime == null) {
            return;
        }
        Long startMillis = callStartTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        this.spendMillis = System.currentTimeMillis() - startMillis;
    }

    public void setCallStartTime(LocalDateTime callStartTime) {
        this.callStartTime = callStartTime;
    }

    public void setRespMsg(String respMsg) {
        this.respMsg = respMsg;
    }

    public void setRespCode(String respCode) {
        this.respCode = respCode;
    }

    public void setErrorClassName(String errorClassName) {
        this.errorClassName = errorClassName;
    }

    public void setErrorLine(Integer errorLine) {
        this.errorLine = errorLine;
    }

    public void setErrorMethod(String errorMethod) {
        this.errorMethod = errorMethod;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void setSpendMillis(Long spendMillis) {
        this.spendMillis = spendMillis;
    }

    public LocalDateTime getCallStartTime() {
        return this.callStartTime;
    }

    public String getRespMsg() {
        return this.respMsg;
    }

    public String getRespCode() {
        return this.respCode;
    }

    public String getErrorClassName() {
        return this.errorClassName;
    }

    public Integer getErrorLine() {
        return this.errorLine;
    }

    public String getErrorMethod() {
        return this.errorMethod;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public Long getSpendMillis() {
        return this.spendMillis;
    }
}

