package com.rocogz.syy.infrastructure.entity.wechat;


import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.common.entity.VersionEntity;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/5/29 10:53</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@TableName(value = "basic_wechat_open_login_log")
public class WechatOpenLoginLog extends IdEntity {

    /**
     * 账号名（平台账户是username，机构是acctname）
     */
    private String acctName;

    /**
     * 账号性质 system,customer
     */
    private String accountNature;

    /**
     * 账号编码（平台账户是id，机构是id）
     */
    private Long accountCode;

    /**
     * 请求参数
     */
    private String logText;

    private String openId;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机
     */
    private String mobile;

    /**
     * 操作类型
     */
    private String operType;

    /**
     * 操作结果
     */
    private String operResult;

    /**
     * 备注
     */
    private String remark;
    /**
     * 操作日期
     */
    @JsonFormat(pattern="yyyy-MM-dd", timezone = "GMT+08:00")
    private LocalDate createDate;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    protected LocalDateTime createTime;

}