package com.rocogz.syy.infrastructure.dto.samsung.resp;

import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.rocogz.syy.infrastructure.util.UpperCaseStrategy;
import lombok.Data;

/**
 * <dl>
 * <dd>Description: 根据 Eventid获得NCMESC产品的支付数据 对象 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2024-07-01 09:15:10</dd>
 * <dd>@author：zhangmin</dd>
 * </dl>
 */
@Data
@JsonNaming(value = UpperCaseStrategy.class)
public class ScPayItemInfoDto {

    /**
     * 申领id，例如：728685251774664704
     */
    private String EVENT_ID;


    /**
     * 订单类型 DI屏碎保  EW延保
     */
    private String ORDER_TYPE;

    /**
     * 支付状态:
     * 0001-未支付
     * 0002-已支付
     * 0003-不需支付
     * 0004-无coupon对应数据
     */
    private String STATUS;

    /**
     * 会员ID
     */
    //private String MEM_ID;

    /**
     * 会员姓名
     */
    //private String MEM_NM;

    /**
     * 支付金额， 单位：分
     */
    private Integer PAY_FEE;


    /**
     * 申领日期：yyyyMMdd,例如：20180202
     */
    private String APPLY_DT;

    /**
     * DI/EW 屏碎保时间或延保时间:值:6M或1Y等  6M表示：6个月, 12M表示 12个月,1Y表示1年
     */
    private String VALID_TYPE;

    /**
     * 支付有效期：例如：2020-06-17 23:59:59
     */
    //private String EXPIRES_TIME;

}
