package com.rocogz.syy.infrastructure.dto.samsung.resp;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 获取支付数据响应 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-11-12 09:12:24</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Setter
@Getter
@ToString
public class GetPayInfoRespDto {

    /**
     * 列表条数
     */
    private String count;

    /**
     * 主活动id
     */
    @JsonProperty("ACTY_ID")
    private String actyId;

    /**
     * 状态： 0000-未支付
     */
    @JsonProperty("STATUS")
    private String status;

    /**
     * 回调地址
     */
    @JsonProperty("NOTIFY_URL")
    private String notifyUrl;

    /**
     * 待支付数据（订单数据）
     */
    private List<PayInfoDto> orderList;
}
