package com.rocogz.syy.infrastructure.dto.samsung.req;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * <dl>
 * <dd>Description: 积分商城5折电池折扣券订单状态修改接口 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-11-10 16:12:26</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class BcouponReceiveParamDto {

    /**
     * 会员号：会员ID和SA GUID必须输入一项，同时输入以会员ID为准
     */
    @NotNull
    private String memberId;

    /**
     * SA GUID：会员ID和SA GUID必须输入一项，同时输入以会员ID为准
     */
    private String saGuid;

    /**
     * 传入'S'代表Spen，'B’代表Battery
     */
    @NotNull
    private String type;

    /**
     * 产品型号
     */
    private String prodModel;

    /**
     * IMEI
     */
    private String imei;

    /**
     * 电池折扣券或者Spen码:与以前不同，无需再以'B'或者'S'开头
     */
    @NotNull
    private String bcouponNo;

    /**
     * 5折电池折扣券或Spen购买日期:日期以XML日期格式为准，例如2018-01-01
     */
    private String bcouponSaleDt;

    /**
     * 5折电池折扣券有效开始日期:日期以XML日期格式为准，例如2018-01-01
     */
    private String bcouponStartDt;

    /**
     * 5折电池折扣券有效结束日期:日期以XML日期格式为准，例如2018-01-01
     */
    private String bcouponEndDt;

    /**
     * 5折电池折扣券购买金额
     */
    private String bcouponAmt;

    /**
     * 5折电池折扣券积分金额
     */
    private String bcouponPntAmt;

    /**
     * 订单号
     */
    private String bcouponSaleNo;

    /**
     * 购买状态:固定值‘A’
     */
    private String bcouponSaleSt;

}
