package com.rocogz.syy.infrastructure.constant;

/**
 * <dl>
 * <dd>Description: 基础服务常量类</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/20 11:43</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
public final class InfrastructureConstant {
    private InfrastructureConstant(){}

    /**
     * 选择区域为全部时的编码
     */
    public static final String AREA_ALL_CODE = "AREA_ALL";

    public static final String MQ_EXCHANGE_NAME = "INFRASTRUCTURE_EXCHANGE";
    public static final String MQ_API_REQUEST_LOG_ROUTE_KEY = "INFRASTRUCTURE_API_REQUEST_LOG";

    public static final String MQ_MALL_API_REQUEST_LOG_ROUTE_KEY = "MALL_API_REQUEST_LOG_KEY";
    public static final String MQ_MALL_API_REQUEST_LOG_QUEUE = "INFRASTRUCTURE_MALL_API_REQUEST_LOG_QUEUE";

    public static final String MQ_MERCHANT_API_REQUEST_LOG_QUEUE = "INFRASTRUCTURE_MERCHANT_API_REQUEST_LOG_QUEUE";
    public static final String MQ_MERCHANT_API_REQUEST_LOG_ROUTE_KEY = "INFRASTRUCTURE_MERCHANT_API_REQUEST_LOG_KEY";

    /**
     * 字典表类型
     */
    public class DictType {
        public final static String USER_DATA_PERMISSION_TYPE = "USER_DATA_PERMISSION_TYPE";


        /**
         * 快递公司
         */
        public final static String EXPRESS_DELIVERY_NAME= "EXPRESS_DELIVERY_NAME";
    }

    /**
     * 字典表数据
     */
    public class DictData {

        /** 供应商，与用户权限表中data_type对应*/
        public final static String USER_DATA_PERMISSION_SUPPLIER = "SUPPLIER";
        public final static String USER_DATA_PERMISSION_SUPPLIER_LABEL = "供应商";

        /** 专区 */
        public final static String USER_DATA_PERMISSION_PREFECTURE = "PREFECTURE";
        public final static String USER_DATA_PERMISSION_PREFECTURE_LABEL = "专区";

        /** 平台商户 */
        public final static String USER_DATA_PERMISSION_ISSUING_BUSINESS = "ISSUING_BUSINESS";
        public final static String USER_DATA_PERMISSION_ISSUING_BUSINESS_LABEL = "发放主体-平台商户";

        /**
         * 发放机构
         */
        public final static String USER_DATA_PERMISSION_ISSUING_ORG = "ISSUING_ORG";
        public final static String USER_DATA_PERMISSION_ISSUING_ORG_LABEL = "发放主体-发放机构";

        /**
         * 合作企业
         */
        public final static String USER_DATA_PERMISSION_ISSUING_ENTERPRISE = "ISSUING_ENTERPRISE";
        public final static String USER_DATA_PERMISSION_ISSUING_ENTERPRISE_LABEL = "发放主体-合作企业";

        /**
         * 结算主体
         */
        public final static String USER_DATA_PERMISSION_SETTLE_SUBJECT = "SETTLE_SUBJECT";
        public final static String USER_DATA_PERMISSION_SETTLE_SUBJECT_LABEL = "结算主体";
    }


    public  static class DictRoleType {
        public static final String TYPE_CODE = "ROLE_TYPE";
        // 系统角色
        public static final String SYS = "system";
        // 平台角色
        public static final String PLATFORM = "platform";
        // 集成商角色
        public static final String BIZ = "biz";
    }

    public  static class DictUserType {
        public static final String TYPE_CODE = "USER_TYPE";
        // 系统用户
        public static final String SYS = "system";
        // 平台用户
        public static final String PLATFORM = "platform";
        // 集成商用户
        public static final String BIZ = "biz";
    }
    public static class IsType{

        public static final String N = "N";

        public static final String Y = "Y";
    }
}
