package com.rocogz.syy.infrastructure.dto.samsung.req;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * <dl>
 * <dd>Description: 根据 Eventid 同步取消订单状态到三星dto (SCME SC产品)
 * scme sc服务订单下单支付成功后，通过admin端申请售后服务取消订单了, 把订单状态同步给三星
 * </dd>
 * 同步接口地址： / api/o/rocomall/syncScOrderCencel
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2024-07-01 09:22:55</dd>
 * <dd>@author：zhangmin</dd>
 * </dl>
 */
@Data
public class SyncScOrderCancelParamDto {

    /**
     * 申领id，接入积分商城url中eventid值，例如：728685251774664704
     */
    @NotNull
    private String eventid;

    /**
     * 订单类型: DI-碎屏险，EW-延保
     */
    @NotNull
    private String orderType;


    /**
     * 已取消状态：R
     */
    @NotNull
    private String orderStatus;

}
