package com.rocogz.syy.infrastructure.dto.samsung.req;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * <dl>
 * <dd>Description: 根据Eventid回写同步支付订单数据到三星dto (SCME SC产品)</dd>
 * 同步接口地址： /api/o/rocomall/syncScOrderType
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2024-07-01 09:22:55</dd>
 * <dd>@author：zhangmin</dd>
 * </dl>
 */
@Data
public class SyncScOrderParamDto {

    /**
     * 申领id，接入积分商城url中eventid值，例如：728685251774664704
     */
    @NotNull
    private String eventid;

    /**
     * 订单类型: DI-碎屏险，EW-延保，QY-爱奇艺， GIFT-礼品兑换，ALL-多类型合并支付
     */
    @NotNull
    private String orderType;


    /**
     * 积分商城的订单号,例如：ROCO2020121100002
     */
    @NotNull
    private String tranID;


    /**
     * 支付现金(无现金支付为0),（单位:分）
     */
    @NotNull
    private String payCash;

    /**
     * 支付积分(无积分支付为0) （单位:分）
     */
    @NotNull
    private String payPoint;

}
