package com.rocogz.merchant.entity.store;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 控制会员核销次数配置
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantLimitRules extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 专区服务项目编号
     */
    private String areaServiceCode;

    /**
     * 区域编号
     */
    private String areaCode;

    /**
     * 范围数：根据类型可能是 1小时 2天 
     */
    private Integer scope;

    /**
     * 次数
     */
    private Integer times;

    /**
     * 类型：1:小时 2:天 3:周 4:月
     */
    private Integer type;

    /**
     * 限制的对象：1:会员 2:车牌
     */
    private Integer target;
}
