package com.rocogz.merchant.entity.brand;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 商户品牌
 * </p>
 *
 * @author yinshihao
 * @since 2020-03-30
 */
@TableName(value = "merchant_brand")
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
public class MerchantBrand extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 品牌编号
     */
    private String code;

    /**
     * 品牌名称
     */
    private String name;

    /**
     * 品牌简称
     */
    private String abbreviation;

    /**
     * 封面地址
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String logoPath;

    /**
     * 所属行业编码
     */
    @TableField(exist = false)
    private List<String> industryCode;

    /**
     * 品牌介绍
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String description;

    /**
     * 状态
     */
    private String status;
}
