/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.merchant.client;

import com.rocogz.merchant.dto.TreeDto;
import com.rocogz.merchant.dto.goods.GoodsStockAdminAdjustRequestDto;
import com.rocogz.merchant.dto.goods.GoodsVcardStockPageRequestDto;
import com.rocogz.merchant.dto.goodsStock.OrderBatchStockRequestDto;
import com.rocogz.merchant.dto.goodsStock.OrderStockRequestDTO;
import com.rocogz.merchant.dto.goodsStock.OrderVCardResponseItem;
import com.rocogz.merchant.dto.goodsVcard.VCardToVoidRequestDTO;
import com.rocogz.merchant.entity.brand.MerchantBrand;
import com.rocogz.merchant.entity.goods.MerchantGoods;
import com.rocogz.merchant.entity.goods.MerchantGoodsClassification;
import com.rocogz.merchant.entity.goods.MerchantGoodsLog;
import com.rocogz.merchant.entity.goods.MerchantGoodsStock;
import com.rocogz.merchant.entity.goods.MerchantGoodsStockLog;
import com.rocogz.merchant.entity.goods.MerchantGoodsVCardStock;
import com.rocogz.merchant.entity.identity.MerchantStoreAccountIdentity;
import com.rocogz.merchant.entity.rocomall.MerchantRocoMallGoods;
import com.rocogz.merchant.entity.rocomall.MerchantRocoMallGoodsLog;
import com.rocogz.merchant.entity.rocomall.MerchantRocoMallGoodsSpecialPrice;
import com.rocogz.merchant.entity.supplier.MerchantSupplier;
import com.rocogz.merchant.entity.supplier.MerchantSupplierUlog;
import com.rocogz.merchant.pager.Sort;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface IMerchantClientService {
    @GetMapping(value={"/api/merchant/brand"})
    public PageTable<MerchantBrand> findMerchantBrandList(@RequestParam(value="code", required=false) String var1, @RequestParam(value="keyword", required=false) String var2, @RequestParam(value="status", required=false) String var3, @RequestParam(value="industryCodeList", required=false) List<String> var4, @RequestParam(value="limit", defaultValue="20") int var5, @RequestParam(value="page", defaultValue="1") int var6);

    @PostMapping(value={"/api/merchant/brand/saveOrUpdateMerchantBrand"})
    public Response saveOrUpdateMerchantBrand(@RequestBody MerchantBrand var1);

    @PostMapping(value={"/api/merchant/brand/addBrandIndustry"})
    public Response addBrandIndustry(@RequestBody MerchantBrand var1);

    @PostMapping(value={"/api/merchant/brand/status"})
    public Response switchMerchantBrandStatus(@RequestBody MerchantBrand var1);

    @GetMapping(value={"/api/merchant/brand/{id}"})
    public Response<MerchantBrand> getMerchantBrandById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/merchant/brand/getAllInfoById/{id}"})
    public Response<MerchantBrand> getMerchantBrandAllInfoById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/merchant/brand/deleteIndustryByCode"})
    public Response deleteIndustryByCode(@RequestParam(value="name") String var1, @RequestParam(value="brandCode") String var2, @RequestParam(value="industryCodeList") List<String> var3);

    @GetMapping(value={"/api/merchant/brand/listwithopen"})
    public Response<List<MerchantBrand>> getMerchantBrandListWithOpen(@RequestParam(value="industryCode", required=false) String var1);

    @PostMapping(value={"/api/merchant/goods/saveMerchantGoods"})
    public Response<String> saveMerchantGoods(@RequestBody MerchantGoods var1);

    @GetMapping(value={"/api/merchant/goods/queryPage"})
    public PageTable<MerchantGoods> merchantGoodsPageTable(@RequestParam(value="keyword", required=false) String var1, @RequestParam(value="code", required=false) String var2, @RequestParam(value="erpGoodsCode", required=false) String var3, @RequestParam(value="brandCode", required=false) String var4, @RequestParam(value="supplierCode", required=false) String var5, @RequestParam(value="goodsClassificationCode", required=false) String var6, @RequestParam(value="saleType", required=false) String var7, @RequestParam(value="status", required=false) String var8, @RequestParam(value="supplierCodeList", required=false) List<String> var9, @RequestParam(value="invented", required=false) String var10, @RequestParam(value="limit", defaultValue="20") int var11, @RequestParam(value="page", defaultValue="1") int var12);

    @GetMapping(value={"/api/merchant/goods/operateStatus"})
    public Response merchantGoodsStatusOperate(@RequestParam(value="code") String var1, @RequestParam(value="status") String var2, @RequestParam(value="updateUser") String var3);

    @GetMapping(value={"/api/merchant/goods/goodsApproveCallBlack"})
    public Response goodsApproveCallBlack(@RequestParam(value="pass") String var1, @RequestParam(value="code") String var2, @RequestParam(value="updateUser") String var3);

    @GetMapping(value={"/api/merchant/goods/deleteGoods"})
    public Response merchantGoodsDeleteByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"/api/merchant/goods/goodsDetail"})
    public Response<MerchantGoods> merchantGoodsDetailByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"/api/merchant/goods/batch/status"})
    public Response merchantGoodsBatchOperateStatus(@RequestParam(value="codes") String[] var1, @RequestParam(value="status") String var2, @RequestParam(value="operateUser") String var3);

    @GetMapping(value={"/api/merchant/goods/findGoodsListByClassificationCode"})
    public Response<List<MerchantGoods>> findGoodsListByClassificationCode(@RequestParam(value="goodsClassificationCode") String var1);

    @GetMapping(value={"/api/merchant/goods/queryPageNoGoods"})
    public PageTable<MerchantGoods> queryPageNoGoods(@RequestParam(value="keyword", required=false) String var1, @RequestParam(value="code", required=false) String var2, @RequestParam(value="noGoodsCodeList", required=false) List<String> var3, @RequestParam(value="brandCode", required=false) String var4, @RequestParam(value="goodsClassificationCode", required=false) String var5, @RequestParam(value="saleType", required=false) String var6, @RequestParam(value="status", required=false) String var7, @RequestParam(value="supplierCodeList", required=false) List<String> var8, @RequestParam(value="queryType", required=false) String var9, @RequestParam(value="limit", defaultValue="20") int var10, @RequestParam(value="page", defaultValue="1") int var11);

    @GetMapping(value={"/api/merchant/goods/findMerchantGoodsListByCodes"})
    public Response<List<MerchantGoods>> findMerchantGoodsListByCodes(@RequestParam(value="codes") List<String> var1);

    @GetMapping(value={"/api/merchant/goods/queryPageNoRocoMallGoods"})
    public PageTable<MerchantGoods> queryPageNoRocoMallGoods(@RequestParam(value="keyword", required=false) String var1, @RequestParam(value="code", required=false) String var2, @RequestParam(value="brandCode", required=false) String var3, @RequestParam(value="goodsClassificationCode", required=false) String var4, @RequestParam(value="saleType", required=false) String var5, @RequestParam(value="status", required=false) String var6, @RequestParam(value="supplierCodeList", required=false) List<String> var7, @RequestParam(value="limit", defaultValue="20") int var8, @RequestParam(value="page", defaultValue="1") int var9);

    @GetMapping(value={"/api/merchant/goodsLog/queryPage"})
    public PageTable<MerchantGoodsLog> merchantGoodsLogPageTable(@RequestParam(value="goodsCode") String var1, @RequestParam(value="limit", defaultValue="20") int var2, @RequestParam(value="page", defaultValue="1") int var3);

    @GetMapping(value={"/api/merchant/supplier"})
    public PageTable<MerchantSupplier> searchSupplier(@RequestParam(name="code", required=false) String var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="status", required=false) String var3, @RequestParam(name="supplierCodeList", required=false) List<String> var4, @RequestParam(name="limit", defaultValue="20") Integer var5, @RequestParam(name="page", defaultValue="1") Integer var6);

    @PostMapping(value={"/api/merchant/supplier/createOrUpdateMerchantSupplier"})
    public Response createOrUpdateMerchantSupplier(@RequestBody MerchantSupplier var1);

    @GetMapping(value={"/api/merchant/supplier/supplierDetail"})
    public Response<MerchantSupplier> merchantMerchantSupplierDetailByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"/api/merchant/supplier/operateStatus"})
    public Response merchantSupplierStatusOperate(@RequestParam(value="code") String var1, @RequestParam(value="status") String var2, @RequestParam(value="updateUser") String var3, @RequestParam(value="reason", required=false) String var4);

    @GetMapping(value={"/api/merchant/supplier/ulog/queryPage"})
    public PageTable<MerchantSupplierUlog> merchantSupplierUlogPageTable(@RequestParam(value="supplierCode") String var1, @RequestParam(value="limit", defaultValue="20") int var2, @RequestParam(value="page", defaultValue="1") int var3);

    @GetMapping(value={"/api/merchant/goods/classification/getTree"})
    public Response<List<TreeDto<MerchantGoodsClassification>>> getMerchantGoodsClassificationTree();

    @GetMapping(value={"/api/merchant/goods/classification/{id}"})
    public Response<MerchantGoodsClassification> getMerchantGoodsClassificationById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/merchant/goods/classification/listByGoodsClassificationCode"})
    public Response<List<MerchantGoodsClassification>> listByGoodsClassificationCode(@RequestParam(value="goodsClassificationCode") String var1);

    @GetMapping(value={"/api/merchant/goods/classification/deleteByGoodsClassCode"})
    public Response deleteByGoodsClassCode(@RequestParam(value="goodsClassificationCode") String var1);

    @GetMapping(value={"/api/merchant/goods/classification"})
    public PageTable<MerchantGoodsClassification> searchMerchantGoodsClassification(@RequestParam(name="code", required=false) String var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="status", required=false) String var3, @RequestParam(name="limit", defaultValue="20") Integer var4, @RequestParam(name="page", defaultValue="1") Integer var5);

    @PostMapping(value={"/api/merchant/goods/classification/saveOrUpdate"})
    public Response saveOrUpdateMerchantGoodsClassification(@RequestBody MerchantGoodsClassification var1);

    @GetMapping(value={"/api/merchant/goods/classification/getOpenTree"})
    public Response<List<TreeDto<MerchantGoodsClassification>>> getOpenTree();

    @GetMapping(value={"/api/merchant/goods/classification/openListByGoodsClassificationCode"})
    public Response<List<MerchantGoodsClassification>> openListByGoodsClassificationCode(@RequestParam(value="goodsClassificationCode") String var1);

    @GetMapping(value={"/api/merchant/goodsstock/queryPage"})
    public PageTable<MerchantGoodsStock> merchantGoodsStockPageTable(@RequestParam(value="goodsCode", required=false) String var1, @RequestParam(value="goodsName", required=false) String var2, @RequestParam(value="brandCode", required=false) String var3, @RequestParam(value="supplierCode", required=false) String var4, @RequestParam(value="supplierCodeList", required=false) List<String> var5, @RequestParam(value="goodsClassificationCode", required=false) String var6, @RequestParam(value="orderBy", required=false, defaultValue="b.id") String var7, @RequestParam(value="sort", required=false, defaultValue="DESC") Sort.Direction var8, @RequestParam(value="limit", defaultValue="20") int var9, @RequestParam(value="page", defaultValue="1") int var10);

    @GetMapping(value={"/api/merchant/goodsstock/exportMerchantGoodsStock"})
    public Response<List<MerchantGoodsStock>> exportMerchantGoodsStock(@RequestParam(value="goodsCode", required=false) String var1, @RequestParam(value="goodsName", required=false) String var2, @RequestParam(value="brandCode", required=false) String var3, @RequestParam(value="supplierCode", required=false) String var4, @RequestParam(value="supplierCodeList", required=false) List<String> var5, @RequestParam(value="goodsClassificationCode", required=false) String var6, @RequestParam(value="orderBy", required=false, defaultValue="b.id") String var7, @RequestParam(value="sort", required=false, defaultValue="DESC") Sort.Direction var8);

    @GetMapping(value={"/api/merchant/goodsstock/getFullInfoByGoodsCode"})
    public Response<MerchantGoodsStock> getFullInfoByGoodsCode(@RequestParam(value="goodsCode") String var1);

    @PostMapping(value={"/api/merchant/goodsstock/adjustStock"})
    public Response adjustStock(@RequestBody GoodsStockAdminAdjustRequestDto var1);

    @GetMapping(value={"/api/merchant/goodsstocklog/queryPage"})
    public PageTable<MerchantGoodsStockLog> merchantGoodsStockLogPageTable(@RequestParam(value="goodsCode", required=false) String var1, @RequestParam(value="limit", defaultValue="20") int var2, @RequestParam(value="page", defaultValue="1") int var3);

    @GetMapping(value={"/api/merchant/supplier/supplierList"})
    public Response<List<MerchantSupplier>> merchantSupplierList();

    @PostMapping(value={"/api/merchant/goodsstock/orderStockOccupied"})
    public Response orderStockOccupied(@RequestBody OrderStockRequestDTO var1);

    @PostMapping(value={"/api/merchant/goodsstock/orderStockReduce"})
    public Response orderStockOut(@RequestBody OrderStockRequestDTO var1);

    @PostMapping(value={"/api/merchant/goodsstock/orderStockCancel"})
    public Response orderStockCancel(@RequestBody OrderStockRequestDTO var1);

    @PostMapping(value={"/api/merchant/goodsstock/orderVCardSend"})
    public Response orderVCardSend(@RequestBody OrderStockRequestDTO var1);

    @GetMapping(value={"/api/merchant/goodsstock/getVCardByOrderNo"})
    public Response<List<OrderVCardResponseItem>> getVCardByOrderNo(@RequestParam(value="orderNo") String var1);

    @PostMapping(value={"/api/merchant/goodsvcardstock/queryPage"})
    public PageTable<MerchantGoodsVCardStock> merchantGoodsVCardStockPageTable(@RequestBody GoodsVcardStockPageRequestDto var1);

    @PostMapping(value={"/api/merchant/goodsvcardstock/importBatchVCard"})
    public Response<Integer> importBatchVCard(@RequestBody List<MerchantGoodsVCardStock> var1);

    @PostMapping(value={"/api/merchant/goods/getSupplierInventedGoodsCodeList"})
    public Response<List<String>> getSupplierInventedGoodsCodeList(@RequestBody List<String> var1);

    @PostMapping(value={"/api/merchant/goodsvcardstock/setVCardToVoid"})
    public Response setVCardToVoid(@RequestBody VCardToVoidRequestDTO var1);

    @GetMapping(value={"/api/merchant/goodsvcardstock/updateVCardExpireTask"})
    public Response updateVCardExpireTask();

    @PostMapping(value={"/api/merchant/goodsstock/orderBatchStockOccupied"})
    public Response orderBatchStockOccupied(@RequestBody @Validated OrderBatchStockRequestDto var1);

    @PostMapping(value={"/api/merchant/goodsstock/orderBatchStockReduce"})
    public Response orderBatchStockReduce(@RequestBody @Validated OrderBatchStockRequestDto var1);

    @PostMapping(value={"/api/merchant/goodsstock/orderBatchStockCancel"})
    public Response orderBatchStockCancel(@RequestBody @Validated OrderBatchStockRequestDto var1);

    @PostMapping(value={"/api/merchant/goodsstock/orderBatchVCardSend"})
    public Response orderBatchVCardSend(@RequestBody @Validated OrderBatchStockRequestDto var1);

    @PostMapping(value={"/api/merchant/merchant-identity"})
    public Response saveOrUpdateMerchantIdentity(@RequestBody MerchantStoreAccountIdentity var1);

    @GetMapping(value={"/api/merchant/merchant-identity/list"})
    public Response<List<MerchantStoreAccountIdentity>> listMerchantStoreIdentity(@RequestParam(value="storeAccountCode", required=false) String var1, @RequestParam(value="identityTypeCode", required=false) String var2);

    @PostMapping(value={"/api/merchant/goodsstock/orderBatchStockRepeatOccupied"})
    public Response orderBatchStockRepeatOccupied(OrderBatchStockRequestDto var1);

    @PostMapping(value={"/api/merchant/goodsstock/merchantGoodsSellableStock"})
    public Response<List<MerchantGoodsStock>> merchantGoodsSellableStock(@RequestBody List<String> var1);

    @PostMapping(value={"/api/merchant/rocoMallGoods/batchSaveRocoMallGoods"})
    public Response batchSaveRocoMallGoods(@RequestBody List<MerchantRocoMallGoods> var1, @RequestParam(value="operationUser") String var2);

    @PostMapping(value={"/api/merchant/rocoMallGoods/editRocoMallGoods"})
    public Response editRocoMallGoods(@RequestBody MerchantRocoMallGoods var1, @RequestParam(value="map") Map var2);

    @GetMapping(value={"/api/merchant/rocoMallGoods/queryPage"})
    public PageTable<MerchantRocoMallGoods> merchantRocoMallGoodsPageTable(@RequestParam(required=false, name="name") String var1, @RequestParam(required=false, name="code") String var2, @RequestParam(required=false, name="brandCode") String var3, @RequestParam(required=false, name="supplierCode") String var4, @RequestParam(required=false, name="goodsClassificationCode") String var5, @RequestParam(required=false, name="goodsStatus") String var6, @RequestParam(required=false, name="rocoMallGoodsStatus") String var7, @RequestParam(value="supplierCodeList", required=false) List<String> var8, @RequestParam(defaultValue="20", name="limit") int var9, @RequestParam(defaultValue="1", name="page") int var10);

    @GetMapping(value={"/api/merchant/rocoMallGoods/operateStatus"})
    public Response merchantRocoMallGoodsStatusOperate(@RequestParam(value="code") String var1, @RequestParam(value="status") String var2, @RequestParam(value="updateUser") String var3);

    @GetMapping(value={"/api/merchant/rocoMallGoods/goodsDetail"})
    public Response<MerchantRocoMallGoods> merchantRocoMallGoodsDetailByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"/api/merchant/rocoMallGoods/goodsDetailByCodeAndUser"})
    public Response<MerchantRocoMallGoods> goodsDetailByCodeAndUser(@RequestParam(value="code") String var1, @RequestParam(value="identityCode") List<String> var2, @RequestParam(value="phone") String var3);

    @GetMapping(value={"/api/merchant/rocoMallGoods/batch/status"})
    public Response merchantRocoMallGoodsBatchOperateStatus(@RequestParam(value="codes") String[] var1, @RequestParam(value="status") String var2, @RequestParam(value="operateUser") String var3);

    @PostMapping(value={"/api/merchant/rocoMallGoods/setSeq"})
    public Response setSeq(@RequestParam(value="code") String var1, @RequestParam(value="seq") Integer var2, @RequestParam(value="updateUser") String var3);

    @GetMapping(value={"/api/merchant/rocoMallGoods/merchantRocoMallGoodsList"})
    public Response<List<MerchantRocoMallGoods>> merchantRocoMallGoodsList();

    @GetMapping(value={"/api/merchant/rocoMallGoods/findRocoMallGoodsList"})
    public PageTable<MerchantRocoMallGoods> findRocoMallGoodsList(@RequestParam(value="openAgentPrice") String var1, @RequestParam(value="keyword", required=false) String var2, @RequestParam(value="sortType") String var3, @RequestParam(value="goodsClassificationCode", required=false) String var4, @RequestParam(value="brandCodeList", required=false) List<String> var5, @RequestParam(value="minPrice", required=false) String var6, @RequestParam(value="maxPrice", required=false) String var7, @RequestParam(value="identityCode") List<String> var8, @RequestParam(value="phone") String var9, @RequestParam(value="limit", defaultValue="20") int var10, @RequestParam(value="page", defaultValue="1") int var11);

    @GetMapping(value={"/api/merchant/rocoMallGoods/getTotalRocoMallGoods"})
    public Response<Integer> getTotalRocoMallGoods(@RequestParam(required=false, value="status") String var1);

    @GetMapping(value={"/api/merchant/rocoMallGoods/findRandomLimitEight"})
    public Response<List<MerchantRocoMallGoods>> findRandomLimitEight();

    @GetMapping(value={"/api/merchant/rocoMallGoods/getGoodsMinAppointPrice"})
    public Response<BigDecimal> getGoodsMinAppointPrice(@RequestParam(value="code") String var1, @RequestParam(value="identityCode") List<String> var2, @RequestParam(value="phone") String var3);

    @GetMapping(value={"/api/merchant/rocoMallGoods/noAccessFindRocoMallGoodsList"})
    public PageTable<MerchantRocoMallGoods> noAccessFindRocoMallGoodsList(@RequestParam(value="keyword", required=false) String var1, @RequestParam(value="sortType") String var2, @RequestParam(value="goodsClassificationCode", required=false) String var3, @RequestParam(value="brandCodeList", required=false) List<String> var4, @RequestParam(value="minPrice", required=false) String var5, @RequestParam(value="maxPrice", required=false) String var6, @RequestParam(value="limit", defaultValue="20") int var7, @RequestParam(value="page", defaultValue="1") int var8);

    @GetMapping(value={"/api/merchant/rocoMallGoodsLog/queryPage"})
    public PageTable<MerchantRocoMallGoodsLog> merchantRocoMallGoodsLogPageTable(@RequestParam(value="goodsCode") String var1, @RequestParam(defaultValue="20", name="limit") int var2, @RequestParam(defaultValue="1", name="page") int var3);

    @PostMapping(value={"/api/merchant/rocoMallGoodsSpecialPrice/importAppointPrice"})
    public Response importAppointPrice(@RequestBody List<MerchantRocoMallGoodsSpecialPrice> var1, @RequestParam(value="updateUser") String var2);

    @GetMapping(value={"/api/merchant/rocoMallGoodsSpecialPrice/getUserIsAgent"})
    public Response getUserIsAgent(@RequestParam(value="phone") String var1);
}

