package com.rocogz.merchant.client;

import com.rocogz.merchant.dto.TreeDto;
import com.rocogz.merchant.dto.goods.GoodsStockAdminAdjustRequestDto;
import com.rocogz.merchant.dto.goods.GoodsVcardStockPageRequestDto;
import com.rocogz.merchant.dto.goodsStock.OrderBatchStockRequestDto;
import com.rocogz.merchant.dto.goodsStock.OrderStockRequestDTO;
import com.rocogz.merchant.dto.goodsStock.OrderVCardResponseItem;
import com.rocogz.merchant.dto.goodsVcard.VCardToVoidRequestDTO;
import com.rocogz.merchant.entity.brand.MerchantBrand;
import com.rocogz.merchant.entity.goods.*;
import com.rocogz.merchant.entity.identity.MerchantStoreAccountIdentity;
import com.rocogz.merchant.entity.rocomall.MerchantRocoMallGoods;
import com.rocogz.merchant.entity.rocomall.MerchantRocoMallGoodsLog;
import com.rocogz.merchant.entity.rocomall.MerchantRocoMallGoodsSpecialPrice;
import com.rocogz.merchant.entity.supplier.MerchantSupplier;
import com.rocogz.merchant.entity.supplier.MerchantSupplierUlog;
import com.rocogz.merchant.pager.Sort;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 商户接口
 *
 * @author：liangyongtong
 * @since：2020/3/25
 */
@SuppressWarnings("all")
public interface IMerchantClientService {


    /*********************************************  yinshihao 商户品牌相关 Start   ****************************************************************/
    /**
     * 查询商户品牌列表(分页)
     *
     * @param code             品牌名
     * @param keyword          所属行业编码
     * @param status           品牌状态
     * @param page             页码
     * @param limit            每页条数
     * @return
     */
    @GetMapping("/api/merchant/brand")
    PageTable<MerchantBrand> findMerchantBrandList(@RequestParam(value = "code", required = false) String code,
                                                   @RequestParam(value = "keyword", required = false) String keyword,
                                                   @RequestParam(value = "status", required = false) String status,
                                                   @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                   @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 新增或编辑商户品牌
     *
     * @param merchantBrand 商户品牌
     * @return
     */
    @PostMapping("/api/merchant/brand/saveOrUpdateMerchantBrand")
    Response saveOrUpdateMerchantBrand(@RequestBody MerchantBrand merchantBrand);


    /**
     * 改变商户品牌状态
     *
     * @param merchantBrand 商户品牌
     * @return
     */
    @PostMapping("/api/merchant/brand/status")
    Response switchMerchantBrandStatus(@RequestBody MerchantBrand merchantBrand);

    /**
     * 根据id查询商户品牌信息
     *
     * @param id 商户品牌id
     * @return
     */
    @GetMapping("/api/merchant/brand/{id}")
    Response<MerchantBrand> getMerchantBrandById(@PathVariable("id") Integer id);

    /**
     * 获取启用的品牌列表
     *
     * @param industryCode 行业编码
     * @return
     */
    @GetMapping("/api/merchant/brand/listWithOpen")
    Response<List<MerchantBrand>> getMerchantBrandListWithOpen();

    /*********************************************   yinshihao 商户品牌 end   ********************************************************************/

    /*********************************************   yinshihao MerchantGoods start   ********************************************************************/

    /**
     * 更新保存商品
     *
     * @param goods
     * @return
     */
    @PostMapping("/api/merchant/goods/saveMerchantGoods")
    Response<String> saveMerchantGoods(@RequestBody MerchantGoods goods);

    /**
     * 商品列表数据查询
     *
     * @param keyword                 名称 模糊匹配
     * @param code                    编码 全匹配
     * @param erpGoodsCode            erp编码 全匹配
     * @param brandCode               品牌编码 全匹配
     * @param supplierCode            供应商编码 全匹配
     * @param goodsClassificationCode 商品分类编码 全匹配
     * @param status                  商品状态
     * @param invented                是否虚拟商品
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/goods/queryPage")
    PageTable<MerchantGoods> merchantGoodsPageTable(@RequestParam(value = "keyword", required = false) String keyword,
                                                    @RequestParam(value = "code", required = false) String code,
                                                    @RequestParam(value = "erpGoodsCode", required = false) String erpGoodsCode,
                                                    @RequestParam(value = "brandCode", required = false) String brandCode,
                                                    @RequestParam(value = "supplierCode", required = false) String supplierCode,
                                                    @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                    @RequestParam(value = "saleType", required = false) String saleType,
                                                    @RequestParam(value = "status", required = false) String status,
                                                    @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                                    @RequestParam(value = "invented", required = false) String invented,
                                                    @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                    @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 操作商品状态
     *
     * @param code       商品编码
     * @param status     目标商品状态
     * @param updateUser 更新用户
     * @return
     */
    @GetMapping("/api/merchant/goods/operateStatus")
    Response merchantGoodsStatusOperate(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status, @RequestParam(value = "updateUser") String updateUser);

    /**
     * 审批回调更改状态（上架审批后回调）
     *
     * @param pass
     * @param code
     * @param updateUser
     * @return
     */
    @GetMapping("/api/merchant/goods/goodsApproveCallBlack")
    Response goodsApproveCallBlack(@RequestParam(value = "pass") String pass, @RequestParam(value = "code") String code, @RequestParam(value = "updateUser") String updateUser);

    /**
     * 根据商品编码删除商品
     *
     * @param code 商品编码
     * @return
     */
    @GetMapping("/api/merchant/goods/deleteGoods")
    Response merchantGoodsDeleteByCode(@RequestParam(value = "code") String code);

    /**
     * 根据商品编码获取商品详情
     *
     * @param code 商品编码
     * @return
     */
    @GetMapping("/api/merchant/goods/goodsDetail")
    Response<MerchantGoods> merchantGoodsDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 批量操作状态上架下架
     *
     * @param codes       待操作的商户服务项目编码列表
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/goods/batch/status")
    Response merchantGoodsBatchOperateStatus(@RequestParam(value = "codes") String[] codes, @RequestParam(value = "status") String status, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 根据商品分类编码获取商品列表(基本信息)
     *
     * @param goodsClassificationCode 商品分类编码
     * @return
     */
    @GetMapping("/api/merchant/goods/findGoodsListByClassificationCode")
    Response<List<MerchantGoods>> findGoodsListByClassificationCode(@RequestParam("goodsClassificationCode") String goodsClassificationCode);

    /**
     * 商品列表数据查询(若传了noGoodsCodeList,则是去掉noGoodsCodeList中的商品信息)
     *
     * @param keyword                 名称 模糊匹配
     * @param code                    编码 模糊匹配
     * @param noGoodsCodeList         不需要查询的编码列表
     * @param brandCode               品牌编码 全匹配
     * @param goodsClassificationCode 商品分类编码 全匹配
     * @param status                  商品状态
     * @param queryType               查询类型
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/goods/queryPageNoGoods")
    PageTable<MerchantGoods> queryPageNoGoods(@RequestParam(value = "keyword", required = false) String keyword,
                                              @RequestParam(value = "code", required = false) String code,
                                              @RequestParam(value = "noGoodsCodeList", required = false) List<String> noGoodsCodeList,
                                              @RequestParam(value = "brandCode", required = false) String brandCode,
                                              @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                              @RequestParam(value = "saleType", required = false) String saleType,
                                              @RequestParam(value = "status", required = false) String status,
                                              @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                              @RequestParam(value = "queryType", required = false) String queryType,
                                              @RequestParam(value = "limit", defaultValue = "20") int limit,
                                              @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据商品编码列表查询对应信息
     *
     * @param codes
     * @return
     */
    @GetMapping("/api/merchant/goods/findMerchantGoodsListByCodes")
    Response<List<MerchantGoods>> findMerchantGoodsListByCodes(@RequestParam(value = "codes") List<String> codes);

    /**
     * 商品列表数据查询(去掉ROCO商城商品中已有的商品信息)
     *
     * @param keyword                 名称 模糊匹配
     * @param code                    编码 模糊匹配
     * @param brandCode               品牌编码 全匹配
     * @param goodsClassificationCode 商品分类编码 全匹配
     * @param status                  商品状态
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/goods/queryPageNoRocoMallGoods")
    PageTable<MerchantGoods> queryPageNoRocoMallGoods(@RequestParam(value = "keyword", required = false) String keyword,
                                                      @RequestParam(value = "code", required = false) String code,
                                                      @RequestParam(value = "brandCode", required = false) String brandCode,
                                                      @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                      @RequestParam(value = "saleType", required = false) String saleType,
                                                      @RequestParam(value = "status", required = false) String status,
                                                      @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                                      @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                      @RequestParam(value = "page", defaultValue = "1") int page);

    /*********************************************   yinshihao MerchantGoods end   ********************************************************************/

    /*********************************************   yinshihao MerchantGoodsLog start   ********************************************************************/

    /**
     * 商品操作日期记录
     *
     * @param goodsCode 商品编码
     * @param limit     每页条数
     * @param page      页码
     * @return
     */
    @GetMapping("/api/merchant/goodsLog/queryPage")
    PageTable<MerchantGoodsLog> merchantGoodsLogPageTable(@RequestParam(value = "goodsCode") String goodsCode,
                                                          @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                          @RequestParam(value = "page", defaultValue = "1") int page);

    /*********************************************   yinshihao MerchantGoodsLog end   ********************************************************************/

    /********************************************* yifenrui 供应商  start******************************************************/

    /**
     * 供应商列表
     *
     * @param code
     * @param name
     * @param status
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/supplier")
    PageTable<MerchantSupplier> searchSupplier(@RequestParam(name = "code", required = false) String code,
                                               @RequestParam(name = "name", required = false) String name,
                                               @RequestParam(name = "status", required = false) String status,
                                               @RequestParam(name = "supplierCodeList", required = false) List<String> supplierCodeList,
                                               @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                               @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 新增和更新供应商
     *
     * @param merchantSupplier
     * @return
     */
    @PostMapping("/api/merchant/supplier/createOrUpdateMerchantSupplier")
    Response createOrUpdateMerchantSupplier(@RequestBody MerchantSupplier merchantSupplier);

    /**
     * 根据供应商编码获取供应商详情
     *
     * @param code 供应商编码
     * @return
     */
    @GetMapping("/api/merchant/supplier/supplierDetail")
    Response<MerchantSupplier> merchantMerchantSupplierDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 操作供应商状态
     *
     * @param code       供应商编码
     * @param status     目标供应商状态
     * @param updateUser 更新用户
     * @return
     */
    @GetMapping("/api/merchant/supplier/operateStatus")
    Response merchantSupplierStatusOperate(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status, @RequestParam(value = "updateUser") String updateUser, @RequestParam(value = "reason", required = false) String reason);

    /**
     * 供应商操作日志记录
     *
     * @param supplierCode 商户编码
     * @param limit        每页条数
     * @param page         页码
     * @return
     */
    @GetMapping("/api/merchant/supplier/ulog/queryPage")
    PageTable<MerchantSupplierUlog> merchantSupplierUlogPageTable(@RequestParam(value = "supplierCode") String supplierCode,
                                                                  @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                  @RequestParam(value = "page", defaultValue = "1") int page);
    /********************************************* yifenrui 供应商  end******************************************************/

    /********************************************* yifenrui 商品分类  start******************************************************/
    /**
     * 获取商品分类树.
     *
     * @return
     */
    @GetMapping("/api/merchant/goods/classification/getTree")
    Response<List<TreeDto<MerchantGoodsClassification>>> getMerchantGoodsClassificationTree();

    /**
     * 根据id查询商品分类.
     *
     * @param id the id
     * @return the by id
     */
    @GetMapping("/api/merchant/goods/classification/{id}")
    Response<MerchantGoodsClassification> getMerchantGoodsClassificationById(@PathVariable("id") Integer id);

    /**
     * 根据商品分类编码获取下级列表.
     *
     * @param goodsClassificationCode 服务分类编码
     * @return the response
     */
    @GetMapping("/api/merchant/goods/classification/listByGoodsClassificationCode")
    Response<List<MerchantGoodsClassification>> listByGoodsClassificationCode(@RequestParam("goodsClassificationCode") String goodsClassificationCode);

    @GetMapping("/api/merchant/goods/classification/deleteByGoodsClassCode")
    Response deleteByGoodsClassCode(@RequestParam("goodsClassificationCode") String goodsClassificationCode);

    /**
     * 分页查询商品分类列表
     *
     * @param code
     * @param name
     * @param status
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/goods/classification")
    PageTable<MerchantGoodsClassification> searchMerchantGoodsClassification(@RequestParam(name = "code", required = false) String code,
                                                                             @RequestParam(name = "name", required = false) String name,
                                                                             @RequestParam(name = "status", required = false) String status,
                                                                             @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                                                             @RequestParam(name = "page", defaultValue = "1") Integer page);

    @PostMapping("/api/merchant/goods/classification/saveOrUpdate")
    Response saveOrUpdateMerchantGoodsClassification(@RequestBody MerchantGoodsClassification merchantGoodsClassification);

    /**
     * 前台获取启用状态商品分类树.
     *
     * @return the prefecture tree
     */
    @GetMapping("/api/merchant/goods/classification/getOpenTree")
    Response<List<TreeDto<MerchantGoodsClassification>>> getOpenTree();

    /**
     * 前台根据商品分类编码查询其启用状态的下级列表
     *
     * @param goodsClassificationCode 商品分类编码
     * @return the response
     */
    @GetMapping("/api/merchant/goods/classification/openListByGoodsClassificationCode")
    public Response<List<MerchantGoodsClassification>> openListByGoodsClassificationCode(@RequestParam("goodsClassificationCode") String goodsClassificationCode);

    /********************************************* yifenrui 商品分类  end******************************************************/

    /********************************************* huhailong 商品库存  start******************************************************/
    /**
     * 库存列表
     *
     * @param goodsCode               商品编码
     * @param goodsName               商品名称
     * @param brandCode               品牌编码
     * @param supplierCode            品牌名称
     * @param goodsClassificationCode 分类编码
     * @param orderBy                 排序字段
     * @param direction               生序降序
     * @param limit                   每页多少条
     * @param page                    当前第几页
     * @return
     */
    @GetMapping("/api/merchant/goodsstock/queryPage")
    PageTable<MerchantGoodsStock> merchantGoodsStockPageTable(
            @RequestParam(value = "goodsCode", required = false) String goodsCode,
            @RequestParam(value = "goodsName", required = false) String goodsName,
            @RequestParam(value = "brandCode", required = false) String brandCode,
            @RequestParam(value = "supplierCode", required = false) String supplierCode,
            @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
            @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
            @RequestParam(value = "orderBy", required = false, defaultValue = "b.id") String orderBy,
            @RequestParam(value = "sort", required = false, defaultValue = "DESC") Sort.Direction direction,
            @RequestParam(value = "limit", defaultValue = "20") int limit,
            @RequestParam(value = "page", defaultValue = "1") int page);


    /**
     * 库存列表导出
     *
     * @param goodsCode
     * @param goodsName
     * @param brandCode
     * @param supplierCode
     * @param supplierCodeList
     * @param goodsClassificationCode
     * @param orderBy
     * @param direction
     * @return
     */
    @GetMapping("/api/merchant/goodsstock/exportMerchantGoodsStock")
    Response<List<MerchantGoodsStock>> exportMerchantGoodsStock(
            @RequestParam(value = "goodsCode", required = false) String goodsCode,
            @RequestParam(value = "goodsName", required = false) String goodsName,
            @RequestParam(value = "brandCode", required = false) String brandCode,
            @RequestParam(value = "supplierCode", required = false) String supplierCode,
            @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
            @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
            @RequestParam(value = "orderBy", required = false, defaultValue = "b.id") String orderBy,
            @RequestParam(value = "sort", required = false, defaultValue = "DESC") Sort.Direction direction);

    /**
     * 获取详细信息，调整库存时使用
     *
     * @param goodsCode
     * @return
     */
    @GetMapping("/api/merchant/goodsstock/getFullInfoByGoodsCode")
    Response<MerchantGoodsStock> getFullInfoByGoodsCode(@RequestParam(value = "goodsCode") String goodsCode);

    /**
     * 适用于后台库存调整 增加，减少，预警调整
     *
     * @param stockAdjustRequest
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/adjustStock")
    Response adjustStock(@RequestBody GoodsStockAdminAdjustRequestDto stockAdjustRequest);

    /**
     * 库存调整日志分页
     *
     * @param goodsCode 商品编码
     * @param limit     每页多少条
     * @param page      当前第几页
     * @return
     */
    @GetMapping("/api/merchant/goodsstocklog/queryPage")
    PageTable<MerchantGoodsStockLog> merchantGoodsStockLogPageTable(
            @RequestParam(value = "goodsCode", required = false) String goodsCode,
            @RequestParam(value = "limit", defaultValue = "20") int limit,
            @RequestParam(value = "page", defaultValue = "1") int page);

    /********************************************* huhailong 商品分类  end******************************************************/


    /********************************************* huhl 数据权限管理  start******************************************************/
    @GetMapping("/api/merchant/supplier/supplierList")
    Response<List<MerchantSupplier>> merchantSupplierList();

    /********************************************* huhl 数据权限管理  end******************************************************/

    /******************************************************huhl 订单库存操作 start******************************************************************/
    /**
     * 订单库存占用
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderStockOccupied")
    Response orderStockOccupied(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 订单库存扣减
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderStockReduce")
    Response orderStockOut(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 订单库存还原
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderStockCancel")
    Response orderStockCancel(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 虚拟库存发货,传递订单号
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderVCardSend")
    Response orderVCardSend(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 根据订单号获取卡密，只传递订单号就行
     *
     * @param orderNo
     * @return
     */
    @GetMapping("/api/merchant/goodsstock/getVCardByOrderNo")
    Response<List<OrderVCardResponseItem>> getVCardByOrderNo(@RequestParam("orderNo") String orderNo);

    /**
     * 展示
     *
     * @param query
     * @return
     */
    @PostMapping("/api/merchant/goodsvcardstock/queryPage")
    PageTable<MerchantGoodsVCardStock> merchantGoodsVCardStockPageTable(@RequestBody GoodsVcardStockPageRequestDto query);

    /**
     * 导入
     *
     * @param vCardStocks
     * @return
     */
    @PostMapping("/api/merchant/goodsvcardstock/importBatchVCard")
    Response<Integer> importBatchVCard(@RequestBody List<MerchantGoodsVCardStock> vCardStocks);

    /**
     * huhl 添加，得到用户供应商权限中的所有虚拟商品编码，为了导入虚拟卡时进行校验
     *
     * @return
     */
    @PostMapping("/api/merchant/goods/getSupplierInventedGoodsCodeList")
    Response<List<String>> getSupplierInventedGoodsCodeList(@RequestBody List<String> supplierCodeList);

    /**
     * @param requestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsvcardstock/setVCardToVoid")
    Response setVCardToVoid(@RequestBody VCardToVoidRequestDTO requestDTO);

    /**
     * 更新无效库存任务
     *
     * @return
     */
    @GetMapping("/api/merchant/goodsvcardstock/updateVCardExpireTask")
    Response updateVCardExpireTask();

    /*******************************************************huhl 订单库存操作 end**************************************************/


    /*********************************************************huhailong 购物车形式订单库存操作***************************************/

    /**
     * 类似购物车形式的 订单库存占用
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchStockOccupied")
    Response orderBatchStockOccupied(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 类似购物车形式的 订单库存发货扣减
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchStockReduce")
    Response orderBatchStockReduce(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 类似购物车形式的 订单库存还原
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchStockCancel")
    Response orderBatchStockCancel(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 类似购物车形式的 订单虚拟卡发货
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchVCardSend")
    Response orderBatchVCardSend(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /*********************************************************huhailong 购物车形式订单库存操作 end***************************************/

    // =========  start of  商户身份   ===========

    /**
     * Save or update merchant identity response.
     *
     * @param merchantIdentity the merchant identity
     * @return the response
     */
    @PostMapping("/api/merchant/merchant-identity")
    Response saveOrUpdateMerchantIdentity(@RequestBody MerchantStoreAccountIdentity merchantIdentity);

    /**
     * List merchant identity response.
     *
     * @param storeAccountCode the storeAccountCode
     * @return the response
     */
    @GetMapping("/api/merchant/merchant-identity/list")
    Response<List<MerchantStoreAccountIdentity>> listMerchantStoreIdentity(@RequestParam(value = "storeAccountCode", required = false) String storeAccountCode,
                                                                           @RequestParam(value = "identityTypeCode", required = false) String identityTypeCode);
    // =========  end of  商户身份   ===========


    /*********************************************************huhailong 购物车形式订单库存操作 begin***************************************/

    /**
     * 业务端 订单库存重复占用，场景订单占用库存，取消后，重新占用库存.
     * 会删除流水记录，重新占用库存
     * @param orderStockRequestDTO 多个商品的库存占用
     * @return
     */
     @PostMapping("/api/merchant/goodsstock/orderBatchStockRepeatOccupied")
     Response orderBatchStockRepeatOccupied(OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 通过商户编码查询可用库存
     * @param codes 商品编码列表
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/merchantGoodsSellableStock")
    Response<List<MerchantGoodsStock>> merchantGoodsSellableStock(@RequestBody List<String> codes);
    /*********************************************************huhailong 购物车形式订单库存操作 end***************************************/

    /********************************************* yinshihao ROCO商城商品  start******************************************************/

    /**
     * 批量新增ROCO商城商品
     *
     * @param rocoMallGoodsList
     * @return
     */
    @PostMapping("/api/merchant/rocoMallGoods/batchSaveRocoMallGoods")
    Response batchSaveRocoMallGoods(@RequestBody List<MerchantRocoMallGoods> rocoMallGoodsList, @RequestParam("operationUser") String operationUser);

    /**
     * 编辑ROCO商城商品
     *
     * @param rocoMallGoods
     * @return
     */
    @PostMapping("/api/merchant/rocoMallGoods/editRocoMallGoods")
    Response editRocoMallGoods(@RequestBody MerchantRocoMallGoods rocoMallGoods, @RequestParam("map") Map map);

    /**
     * ROCO商城商品列表数据查询
     *
     * @param name                    名称 模糊匹配
     * @param code                    编码 模糊匹配
     * @param brandCode               品牌编码 全匹配
     * @param supplierCode            供应商编码 全匹配
     * @param goodsClassificationCode ROCO商城商品分类编码 全匹配
     * @param goodsStatus             商品状态
     * @param rocoMallGoodsStatus     ROCO商城商品状态
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/queryPage")
    PageTable<MerchantRocoMallGoods> merchantRocoMallGoodsPageTable(@RequestParam(required = false, name = "name") String name,
                                                                    @RequestParam(required = false, name = "code") String code,
                                                                    @RequestParam(required = false, name = "brandCode") String brandCode,
                                                                    @RequestParam(required = false, name = "supplierCode") String supplierCode,
                                                                    @RequestParam(required = false, name = "goodsClassificationCode") String goodsClassificationCode,
                                                                    @RequestParam(required = false, name = "goodsStatus") String goodsStatus,
                                                                    @RequestParam(required = false, name = "rocoMallGoodsStatus") String rocoMallGoodsStatus,
                                                                    @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                                                    @RequestParam(defaultValue = "20", name = "limit") int limit,
                                                                    @RequestParam(defaultValue = "1", name = "page") int page);

    /**
     * 操作ROCO商城商品状态
     *
     * @param code       ROCO商城商品编码
     * @param status     目标ROCO商城商品状态
     * @param updateUser 更新用户
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/operateStatus")
    Response merchantRocoMallGoodsStatusOperate(@RequestParam("code") String code, @RequestParam("status") String status, @RequestParam("updateUser") String updateUser);

    /**
     * 根据ROCO商城商品编码获取ROCO商城商品详情
     *
     * @param code ROCO商城商品编码
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/goodsDetail")
    Response<MerchantRocoMallGoods> merchantRocoMallGoodsDetailByCode(@RequestParam("code") String code);

    /**
     * 前端根据ROCO商城商品编码和用户信息获取ROCO商城商品详情
     *
     * @param code ROCO商城商品编码
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/goodsDetailByCodeAndUser")
    Response<MerchantRocoMallGoods> goodsDetailByCodeAndUser(@RequestParam("code") String code,
                                                             @RequestParam(value = "identityCode") List<String> identityCode,
                                                             @RequestParam(value = "phone") String phone);

    /**
     * 批量操作状态上架下架
     *
     * @param codes       待操作的商户服务项目编码列表
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/batch/status")
    Response merchantRocoMallGoodsBatchOperateStatus(@RequestParam("codes") String[] codes, @RequestParam("status") String status, @RequestParam("operateUser") String operateUser);

    /**
     * 设置排序值
     *
     * @param code
     * @param seq
     * @param updateUser
     * @return
     */
    @PostMapping("/api/merchant/rocoMallGoods/setSeq")
    Response setSeq(@RequestParam("code") String code, @RequestParam("seq") Integer seq, @RequestParam("updateUser") String updateUser);

    /**
     * 查询所有ROCO商城商品列表
     *
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/merchantRocoMallGoodsList")
    Response<List<MerchantRocoMallGoods>> merchantRocoMallGoodsList();

    /**
     * 前台查询ROCO商城商品列表
     *
     * @param openAgentPrice
     * @param keyword
     * @param sortType
     * @param goodsClassificationCode
     * @param brandCodeList
     * @param minPrice
     * @param maxPrice
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/findRocoMallGoodsList")
    PageTable<MerchantRocoMallGoods> findRocoMallGoodsList(@RequestParam("openAgentPrice") String openAgentPrice,
                                                           @RequestParam(value = "keyword", required = false) String keyword,
                                                           @RequestParam(value = "sortType") String sortType,
                                                           @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                           @RequestParam(value = "brandCodeList", required = false) List<String> brandCodeList,
                                                           @RequestParam(value = "minPrice", required = false) String minPrice,
                                                           @RequestParam(value = "maxPrice", required = false) String maxPrice,
                                                           @RequestParam(value = "identityCode") List<String> identityCode,
                                                           @RequestParam(value = "phone") String phone,
                                                           @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                           @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据ROCO商城商品状态查询总数
     *
     * @param status ROCO商城商品状态,若不传则代表查询所有状态的商品
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/getTotalRocoMallGoods")
    Response<Integer> getTotalRocoMallGoods(@RequestParam(required = false, value = "status") String status);

    /**
     * 前端获取随机8件上架的ROCO商城商品
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/findRandomLimitEight")
    Response<List<MerchantRocoMallGoods>> findRandomLimitEight();

    /**
     * 前端根据ROCO商城商品编码和用户信息获取ROCO商城商品最低价格
     *
     * @param code ROCO商城商品编码
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/getGoodsMinAppointPrice")
    Response<BigDecimal> getGoodsMinAppointPrice(@RequestParam("code") String code,
                                                 @RequestParam(value = "identityCode") List<String> identityCode,
                                                 @RequestParam(value = "phone") String phone);

    /**
     * 前台匿名查询ROCO商城商品列表
     *
     * @param keyword
     * @param sortType
     * @param goodsClassificationCode
     * @param brandCodeList
     * @param minPrice
     * @param maxPrice
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/noAccessFindRocoMallGoodsList")
    PageTable<MerchantRocoMallGoods> noAccessFindRocoMallGoodsList(@RequestParam(value = "keyword", required = false) String keyword,
                                                           @RequestParam(value = "sortType") String sortType,
                                                           @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                           @RequestParam(value = "brandCodeList", required = false) List<String> brandCodeList,
                                                           @RequestParam(value = "minPrice", required = false) String minPrice,
                                                           @RequestParam(value = "maxPrice", required = false) String maxPrice,
                                                           @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                           @RequestParam(value = "page", defaultValue = "1") int page);

    /********************************************* yinshihao ROCO商城商品  end******************************************************/

    /********************************************* yinshihao ROCO商城商品操作日志  start******************************************************/

    /**
     * ROCO商城商品操作日期记录
     *
     * @param goodsCode 商品编码
     * @param limit     每页条数
     * @param page      页码
     * @return
     */

    @GetMapping("/api/merchant/rocoMallGoodsLog/queryPage")
    PageTable<MerchantRocoMallGoodsLog> merchantRocoMallGoodsLogPageTable(@RequestParam("goodsCode") String goodsCode,
                                                                          @RequestParam(defaultValue = "20", name = "limit") int limit,
                                                                          @RequestParam(defaultValue = "1", name = "page") int page);

    /********************************************* yinshihao ROCO商城商品操作日志  end******************************************************/

    /********************************************* yinshihao ROCO商城商品特价  start******************************************************/

    /**
     * 导入
     *
     * @param merchantRocoMallGoodsSpecialPriceList
     * @param updateUser
     * @return
     */
    @PostMapping("/api/merchant/rocoMallGoodsSpecialPrice/importAppointPrice")
    Response importAppointPrice(@RequestBody List<MerchantRocoMallGoodsSpecialPrice> merchantRocoMallGoodsSpecialPriceList, @RequestParam("updateUser") String updateUser);

    /**
     * 根据手机号查询该用户是否是代理人
     *
     * @param phone
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoodsSpecialPrice/getUserIsAgent")
    Response getUserIsAgent(@RequestParam(value = "phone") String phone);

    /********************************************* yinshihao ROCO商城商品特价  end******************************************************/
}

