package com.rocogz.merchant.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.merchant.constant.MerchantGoodsConstant;
import com.rocogz.merchant.entity.attechment.MerchantAttechment;
import com.rocogz.merchant.entity.brand.MerchantBrand;
import com.rocogz.merchant.entity.supplier.MerchantSupplier;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 商品基本信息表
 * </p>
 * @author zhangmin
 * @since 2020-06-16
 */
@Setter @Getter @Accessors(chain = true)
public class MerchantGoods extends UserTimeEntity {

    /**
     * 商品编码
     */
    private String code;

    /**
     * 商品名称
     */
    private String name;

    /**
     * 商品分类编码
     */
    private String classifyCode;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 品牌编码
     */
    private String brandCode;

    /**
     * 是否虚拟商品
     */
    private Boolean virtual;

    /**
     * 虚拟商品类型：卡券、充值、碎屏险、 电池券/换壳券
     * @see MerchantGoodsConstant.DictVirtualProductType
     */
    private String virtualType;

    /**
     * 列表图:路径可能会被分割成几个对应比列的图
     */
    private String listImgUrl;

    /**
     * 搜索关键字
     */
    private String keyword;

    /**
     * 商品支付方式：纯积分、现金抵扣积分、固定积分+固定现金
     * @see MerchantGoodsConstant.DictProductPayWay
     */
    private String payWay;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 是否支持花呗分期
     */
    private Boolean pcreditSupported;

    /**
     * 是否管家专项服务
     */
    private Boolean butlerService;

    /**
     * 是否有销售规格属性
     */
    private Boolean hasSku;

    /**
     * 显示排序位置值
     */
    private Integer seq;

    /**
     * 商品状态
     * @see MerchantGoodsConstant.DictProductStatus
     */
    private String status;

    /**
     * 商品详情介绍
     */
    private String detail;

    //========> 以下是非持久化属性

    @TableField(exist = false)
    private List<MerchantGoodsLabel> labelList;

    @TableField(exist = false)
    private List<MerchantSkuAttr> skuAttrList;

    @JsonIgnore
    @TableField(exist = false)
    private List<MerchantSku> skuList;

    /**
     * 详情图片列表
     */
    @TableField(exist = false)
    private List<MerchantAttechment> detailImages;

    /**
     * 品牌对象
     */
    @TableField(exist = false)
    private MerchantBrand brand;

    /**
     * 供应商对象
     */
    @TableField(exist = false)
    private MerchantSupplier supplier;

    /**
     * 商品分类对象
     */
    @TableField(exist = false)
    private MerchantGoodsClassification classify;

    /**
     * 操作日志
     */
    @TableField(exist = false)
    private List<MerchantGoodsLog> logList;

    //状态label
    private transient String statusLabel;

}
